<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('grid_tile_types', function (Blueprint $table) {
            // add new column image_preview
            $table->string('image_preview')->nullable()->after('template');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('grid_tile_types', function (Blueprint $table) {
            // drop column image_preview
            $table->dropColumn('image_preview');
        });
    }
};
