<?php

namespace Mtc\Modules\Members\Classes\Events;

use Mtc\Modules\Members\Classes\MemberManager;
use Mtc\Modules\Members\Models\Member;

/**
 * Class MemberEvent
 *
 * Base class for some member events.
 *
 * @author Aleksey Lavrinenko <aleksey.lavrinenko@mtcmedia.co.uk>
 */
class MemberEvent
{
    /**
     * The member manage instance handling the member operation
     *
     * @var MemberManager
     */
    public $member_manager;

    /**
     * Member form request data
     *
     * @var array
     */
    public $request_data;

    /**
     * The member instance
     *
     * @var Member
     */
    public $member;

    /**
     * @param MemberManager $member_manager
     * @param array $member_data
     * @param Member $member
     */
    public function __construct(MemberManager $member_manager, array $member_data, Member $member = null)
    {
        $this->member_manager = $member_manager;
        $this->request_data = $member_data;
        $this->member = $member;
    }
}
