(function () {
    if (!window.Vue) return;

    var boot = (window.bootstrap && typeof window.bootstrap === 'object') ? window.bootstrap : {};
    var responses = boot.responses;

    if (!responses || typeof responses !== 'object') {
        responses = {};
        boot.responses = responses;
    }

    if (!window.bootstrap || typeof window.bootstrap !== 'object') {
        window.bootstrap = boot;
    }

    if (!window.PatientProfileBootstrap || typeof window.PatientProfileBootstrap !== 'object') {
        window.PatientProfileBootstrap = window.bootstrap;
    }

    var hasOwn = Object.prototype.hasOwnProperty;

    Vue.mixin({
        data: function () {
            return {
                bootstrap: boot
            };
        },
        methods: {
            consumeBootstrap: function (key) {
                if (!responses || !hasOwn.call(responses, key)) {
                    return null;
                }
                var payload = responses[key];
                delete responses[key];
                return payload;
            },
            cacheBootstrap: function (key, payload) {
                if (!key || !responses || typeof responses !== 'object') {
                    return;
                }

                if (typeof this.$set === 'function') {
                    this.$set(responses, key, payload);
                } else {
                    responses[key] = payload;
                }

                if (boot && typeof boot === 'object') {
                    if (!boot.responses || typeof boot.responses !== 'object') {
                        if (typeof this.$set === 'function') {
                            this.$set(boot, 'responses', responses);
                        } else {
                            boot.responses = responses;
                        }
                    }

                    if (typeof this.$set === 'function') {
                        this.$set(boot.responses, key, payload);
                    } else {
                        boot.responses[key] = payload;
                    }
                }
            }
        }
    });
})();
