Vue.component('patientConsultations', {
    props: ['routes','events','initialConsultations','initialToday'],

    data: function() {
        const initialProvided = Array.isArray(this.initialConsultations);
        const initial = initialProvided ? this.initialConsultations.slice() : [];
        const today = this.initialToday || null;
        return {
            records: initial,          // always keep as array
            hasLoaded: initialProvided,
            loading: false,
            display: 3,
            todayDate: today,
            showingAll: false,
        };
    },

   mounted() {
       this.init();
   },

    watch: {
        initialConsultations: {
            immediate: true,
            handler(list) {
                if (!Array.isArray(list)) return;
                this.records = list.slice();
                this.hasLoaded = true;
                this.loading = false;
            }
        },
        initialToday: {
            immediate: true,
            handler(value) {
                if (value) {
                    this.todayDate = value;
                }
            }
        }
    },

    computed: {
        canShowAll() {
            const list = Array.isArray(this.records) ? this.records : [];
            if (!list.length) return false;
            if (this.showingAll) return false;
            return list.length > this.display;
        }
    },

    methods: {
        init() {
            if (this.hasLoaded) return;
            this.load(true);
        },

        load(force = false) {
            if (!force && this.loading) {
                return;
            }
            const vm = this;
            const cached = (!force && this.consumeBootstrap)
                ? this.consumeBootstrap('admin-patient-consultations-load')
                : null;
            if (cached) {
                const list  = Array.isArray(cached.consultations) ? cached.consultations : [];
                const today = cached?.todayDate ?? null;
                vm.records   = list;
                vm.todayDate = today;
                vm.loading   = false;
                vm.hasLoaded = true;
                if (typeof vm.cacheBootstrap === 'function') {
                    vm.cacheBootstrap('admin-patient-consultations-load', {
                        consultations: list.slice(),
                        todayDate: today,
                    });
                }
                return;
            }

            this.loading = true;

            this.$http.post(this.routes['admin-patient-consultations-load'], {})
                .then((response) => {
                    let payload = response.data;

                    // vue-resource 0.9.x may return JSON as a string
                    if (typeof payload === 'string') {
                        try { payload = JSON.parse(payload); }
                        catch (e) {
                            console.error('Invalid JSON from admin-patient-consultations-load', e, payload);
                            payload = {};
                        }
                    }

                    const list  = Array.isArray(payload?.consultations) ? payload.consultations : [];
                    const today = payload?.todayDate ?? null;

                    vm.records   = list;      // keep as array
                    vm.todayDate = today;
                    vm.loading   = false;
                    vm.hasLoaded = true;
                    if (typeof vm.cacheBootstrap === 'function') {
                        vm.cacheBootstrap('admin-patient-consultations-load', {
                            consultations: list.slice(),
                            todayDate: today,
                        });
                    }
                })
                .catch((err) => {
                    console.error('Consultations load failed:', err);
                    this.loading = false;
                    this.records = [];        // avoid undefined in render
                });
        },

        showAll() {
            this.showingAll = true;
        },
    },
});
