<?php

namespace Mtc\Plugins\GridManager\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Mtc\Plugins\GridManager\Models\GridCssClass;

class GridCssClassController extends Controller
{
    protected $admin_user;
    // Constructor
    public function __construct()
    {
        $this->admin_user = new \AdminUser();
    }
    /**
     * @description Display a listing of the resource.
     */
    public function index()
    {
        return response()->json([
            'status'  => 'success',
            'message' => 'Grid CSS classes loaded successfully',
        ], 200);
    }

    /**
     * @description Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // Validate the request data
        $request->validate([
            'class' => 'required|string|max:255',
            'description' => 'nullable|string|max:500',
        ]);

        // Create a new GridCssClass instance
        $gridCssClass = new GridCssClass();
        $gridCssClass->class = $request->class;
        $gridCssClass->description = $request->description;
        $gridCssClass->last_modified_by = $this->admin_user->user['username'];
        $gridCssClass->ip_address = $request->ip();
        $gridCssClass->save();

        return response()->json([
            'status'  => 'success',
            'message' => 'Grid CSS class created successfully',
            'data'    => $gridCssClass,
        ], 201);
    }

    /**
     * @description Display the specified resource.
     */
    public function all()
    {
        // Retrieve all grid CSS classes
        $gridCssClasses = GridCssClass::all();
        return response()->json([
            'status'  => 'success',
            'message' => 'Grid CSS classes retrieved successfully',
            'data'    => $gridCssClasses,
        ], 200);
    }

    /**
     * @description Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        // Validate the request data
        $request->validate([
            'id' => 'required|integer|exists:grid_css_classes,id',
            'class' => 'required|string|max:255',
            'description' => 'nullable|string|max:500',
        ]);
        $id = $request->input('id');

        // Find the GridCssClass by ID and update it
        $gridCssClass = GridCssClass::findOrFail($id);
        $gridCssClass->fill($request->all());
        $gridCssClass->save();

        return response()->json([
            'status'  => 'success',
            'message' => 'Grid CSS class updated successfully',
            'data'    => $gridCssClass,
        ], 200);
    }

    /**
     * @description Remove the specified resource from storage.
     */
    public function delete(Request $request)
    {
        // Validate the request data
        $request->validate([
            'id' => 'required|integer|exists:grid_css_classes,id',
        ]);


        // Find the GridCssClass by ID and delete it
        $gridCssClass = GridCssClass::findOrFail($request->input('id'));
        $gridCssClass->delete();

        return response()->json([
            'status'  => 'success',
            'message' => 'Grid CSS class deleted successfully',
        ], 200);
    }
}
