<?php

namespace Mtc\Plugins\GridManager\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Mtc\Plugins\GridManager\Models\GlobalBlocks;

class GridGlobalBlocksController extends Controller
{
    protected $admin_user;

    // constructor
    public function __construct()
    {
        $this->admin_user = new \AdminUser();
    }

    /**
     * @description Display a listing of the resource.
     */
    public function index()
    {
        return response()->json([
            'status'  => 'success',
            'message' => 'Global blocks loaded successfully',
        ], 200);
    }

    /**
     * @description Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // Validate the request data
        $request->validate([
            'json' => 'required|json',
        ]);

        $jsonData = $request->input('json');

        // if json data exists in database, return error
        if (GlobalBlocks::where('json', $jsonData)->exists()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Global block with this JSON already exists',
            ], 400);
        }
        else {
            // Create a new GlobalBlocks instance
            $globalBlock = new GlobalBlocks();
            $globalBlock->json = $jsonData;
            $globalBlock->last_modified_by = $this->admin_user->user['username'];
            $globalBlock->ip_address = $request->ip();

            // Save the GlobalBlocks instance
            if ($globalBlock->save()) {
                return response()->json([
                    'status' => 'success',
                    'message' => 'Global block created successfully',
                    'data' => $globalBlock,
                ], 201);
            } else {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Failed to create global block',
                ], 500);
            }

        }
    }

    /**
     * Display the specified resource.
     */
    public function all(GlobalBlocks $globalBlocks)
    {
        $allblocks = $globalBlocks::all();
        // get the json field from each block
        $blocksData = $allblocks->map(function ($blocks) {
            $blockJson = json_decode($blocks->json, true);
            $blockJson['id'] = $blocks->id;
            return $blockJson;
        });
        return response()->json([
            'status' => 'success',
            'data' => $blocksData,
        ], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, GlobalBlocks $globalBlocks)
    {
        // Validate the request data
        $request->validate([
            'json' => 'required|json',
        ]);

        // Update the GlobalBlocks instance
        $globalBlocks->json             = $request->input('json');
        $globalBlocks->last_modified_by = $this->admin_user->user['username'];
        $globalBlocks->ip_address       = $request->ip();

        // Save the changes
        if ($globalBlocks->save()) {
            return response()->json([
                'status'  => 'success',
                'message' => 'Block template updated successfully',
            ], 200);
        }

        return response()->json([
            'status'  => 'error',
            'message' => 'Failed to update global block',
        ], 500);

    }

    /**
     * Remove the specified resource from storage.
     */
    public function delete(GlobalBlocks $globalBlocks, Request $request)
    {
        // get the ID from the request
        $id = $request->input('id');
        // validate the ID
        if (!$id || !is_numeric($id)) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Invalid ID provided',
            ], 400);
        }
        // delete the GlobalBlocks instance by ID
        if ($globalBlocks::where('id', $id)->delete()) {
            return response()->json([
                'status'  => 'success',
                'message' => 'Block template deleted successfully',
            ], 200);
        }
        else {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to delete global block',
            ], 500);
        }
    }
}
