<?php

namespace Mtc\Plugins\GridManager\Models;
use Illuminate\Database\Eloquent\Model;

/**
 * @description GridCssClass Model. This model is used to manage css classes in the GridManager plugin. Primarily used for storing css classes in a database.
 * @extends Model
 * @author Nithika Senaweera <nithika.senaweera@mtc.co.uk>
 * @copyright MTC 2025. <https://mtcmedia.co.uk>
 * @version 2.0.0
 * */
class GridCssClass extends Model
{
    // table name
    protected $table = "grid_css_classes";

    // fillable attributes
    protected $fillable = [
        'class',
        'description',
        'last_modified_by',
        'ip_address',
    ];
}
