<?php

/**
 * This script does one thing only depending on $_POST['action']
 * @author Jindřich Prokop <dev.jp@mtcmedia.co.uk>
 * @contributor Nithika Senaweera <nithika.senaweera@mtc.co.uk>
 * @version 0.2
 */

$path = '../../../';
require $path . 'core/includes/header.inc.php';

use Mtc\Cms\Models\PageList;
use Mtc\Plugins\GridManager\Http\Controllers\GridManager;
use Mtc\Plugins\GridManager\Models;
use Mtc\Plugins\GridManager\Models\Grid as GridModel;

if (!isset($_POST['action'])) {
    die(json_encode(['error' => 'Undefined action']));
}

switch ($_POST['action']) {
    case 'add grid':
        $page = new Page();
        if (isset($_POST['page_id']) && is_numeric($_POST['page_id'])) {
            $page->Get($_POST['page_id']);
        } else {
            die('Page not found.');
        }

        $grid = GridModel::create([
                'page_id' => $_POST['page_id'],
                'title'   => $_POST['new_pagedata_name'],
                'type' => 'cms'
            ]
        );

        $_POST['new_pagedata_type'] = 'grid';
        $_POST[PAGE_LIST_COLUMN_COLUMN] = $grid->id;


        // IMPORTANT: this is the place that actually adds the grid to pagedata
        $ContentManager = new ContentManager();
        $ContentManager->processAddPagedata($_POST, $page);
        Pagedata::orderFix($page->id);
        $page->Save(); // clear cache

        $pagedata = new Pagedata();
        $pagedata->Get($_POST['page_id']);

        $_POST['pagedata_lists'][0] = end($pagedata->pagedata);
        $_POST['pagedata_lists'] = json_encode($_POST['pagedata_lists']);
        $cms_root_path = $path . 'cms/';

        GridManager::clearGridCache($grid->id);

        require SITE_PATH . '/cms/admin/content_manager/templates/edit_page_lists.php';
        break;

    case 'delete grid':
        // sanitize post data
        if (!isset($_POST['grid_id']) || !is_numeric($_POST['grid_id'])) {
            die(json_encode(['error' => 'Invalid grid ID']));
        }
        $sanitized_grid_id = (int) $_POST['grid_id'];
        $grid = GridModel::find($sanitized_grid_id);
        $parent_id = $grid->page_id;
        $grid_structure = Models\GridStructures::where('parent_id', $parent_id)->delete();
        $grid->delete();
        break;

    default:
        break;
}
