<?php

$path = '../../../';
$page['title'] = "Category Landing Page Grid";

require_once $path . 'core/includes/header.inc.php';
include $path . "core/admin/templates/adminheader.html.php";


// make sure we have all the necessary data for the grid
if (!isset($_REQUEST['grid_type'], $_REQUEST['parent_id'])) {
    echo "Missing required parameters.";
    die();
}
else {
    $parent_id = (int)$_REQUEST['parent_id'];
    $grid_type = $_REQUEST['grid_type'];
}

$t = app()->twig;
echo $t->render('admin/styles.twig');
?>
<div id="grid_vue_environment">
    <grid-main
        parent-id="<?= htmlspecialchars($parent_id) ?>"
        parent-type="<?= htmlspecialchars($grid_type) ?>"
    ></grid-main>
</div>
<?php
HooksAdapter::add_action('admin_footer', function () {
    $t = app()->twig;
    echo $t->render('admin/scripts.twig');
});

include $path . "core/admin/templates/adminfooter.html.php";
