/**
 * dialog asking for grid name to be added
 */
function addGrid() {
    'use strict';

    if (busyLoading()) {
        return false;
    }

    var title = "Add a Grid",
        text = "<p>Provide a grid title.</p>";

    text += "<form class='dialogBoxForm' onkeypress='return event.keyCode != 13;'>";
    text += "<fieldset>";
    text += "<div class='row'>";
    text += "<label>Name: &nbsp;</label>";
    text += "<input type='text' name='new_grid_title' id='new_grid_title' class='text ui-widget-content ui-corner-all' />";
    text += "</div>";
    text += "</fieldset>";
    text += "</form>";

    $('#dialog').html(text);

    $('#dialog').dialog('option', 'width', '600px');
    $('#dialog').dialog('option', 'title', title);
    $('#dialog').dialog('option', 'buttons', {
        Add: function () {
            ldrPending("adding grid ...");

            var data = {
                action : 'add grid',
                page_id : getPageId(),
                new_pagedata_name : $("#new_grid_title").val()
            };

            $.post('/plugins/GridManager/admin/cms_grid_manager.php', data).done(function (result) {
                var pagedata = $(result);

                if ($("ul.pagedata-list").html() === "<p>No Content</p>") {
                    $("ul.pagedata-list").html("");
                }
                $("ul.pagedata-list").append(result);
                pagedataInit("#"+pagedata.attr("id"));
                ldrSuccess();
            });

            setUnsavedChanges(true);

            $('#dialog').dialog('close');
        },
        Cancel: function () {
            $('#dialog').dialog('close');
        }
    });
    $('#dialog').dialog('open');
    return false;
}



/**
 * removes grid with triggering button
 *
 * @param {Object} btn
 */
function removeGrid(btn) {
    'use strict';

    if (busyLoading()) {
        return false;
    }

    var item = btn.closest('li'),
        grid = item.find('.grid');

    $('#dialog').dialog('option', 'width', '600px');
    $('#dialog').dialog('option', 'title', "Remove from page or delete?");
    $('#dialog').html('Would you like to unlink the grid from this page or completely delete it?');
    $('#dialog').dialog('option', 'buttons', {
        Delete: function () {
            ldrPending('deleting grid...');
            var data = {
                action : 'delete grid',
                grid_id : grid.attr('data-grid-id')
            };

            $.post('/plugins/GridManager/admin/cms_grid_manager.php', data).done(function (result) {
                grid.closest('li').remove();
                setUnsavedChanges(true);
                ldrSuccess();
            });
            $('#dialog').dialog('close');
        },
        Cancel: function () {
            $('#dialog').dialog('close');
        }
    });
    $('#dialog').dialog('open');
}
