
export const createElement = (type, customProps = {}) => {
    const baseElements = {
        content: { type: 'content', label: 'Content', text: 'New content' },
        image: { type: 'image', label: 'Image', src: '', alt: 'Image' },
        button: { type: 'button', label: 'Button', text: 'Click Me' },
        // Add more base templates as needed
    };

    const baseElement = baseElements[type] || {
        type,
        label: type.charAt(0).toUpperCase() + type.slice(1),
        ...customProps
    };

    return {
        id: `element-${Date.now()}-${Math.random().toString(36).substr(2, 9)}`,
        published: true,
        cssClasses: '',
        ...baseElement,
        ...customProps
    };
};
