$(document).ready(function () {
    //Only run for CM pages
    if (typeof content_manager === 'undefined') {
        return false;
    }

    /**
     * add to CMS pagedataInit
     */
    var cmsPagedataInit = pagedataInit;

    pagedataInit = function (dom_scope) {
        'use strict';
        cmsPagedataInit.apply(this, arguments);

        $('#workArea').on('click', '.remove-grid-btn', function(event) {
            cmsPreventDefault(event);
            removeGrid($(this));
        });


        $(document.body).on('change', '#new_pagedata_type', function(event) {
            cmsPreventDefault(event);
            if ($(this).val() == 'grid') {
                $('#dialog').dialog('close');
                addGrid();
            }
        });

    };

    /**
     * call native CMS savePage() and display issues within tiles
     * in the tile preview
     */
    var cmsSavePage = savePage;

    savePage = function savePage() {
        'use strict';
        if (busyLoading()) {
            return false;
        }

        cmsSavePage.apply(this, arguments);

        $(document).ajaxStop(function() {
            $(this).unbind("ajaxStop");
        });
    };
});
