<?php

/**
 * @description Grid manager plugin - version 2.0.
 *
 * @version 2.0
 * @author Nithika Senaweera <nithika.senaweera@mtc.co.uk>
 * @author Kieran Mcburney <kieran.mcburney@mtc.co.uk>
 * @author   Efraim Zakarias <efraim.zakarias@mtc.co.uk>
 * @contributor Jindřich Prokop <jindrich.prokop@mtcmedia.co.uk>
 * @copyright 2025 mtc. http://www.mtc.co.uk/
 *
 */
use Mtc\Plugins\GridManager\Http\Controllers\GridManager;
use Twig\TwigFunction;

$plugin_name = 'Grid Manager';


ContentManager::$pagedata_types['grid'] = 'Grid Manager';
ContentManager::$pagelist_render_rules['render'][] = 'grid';
ContentManager::$pagelist_render_rules['skip'][] = 'tile';

// Render grid in the admin area.
HooksAdapter::add_action(
    'cms_render_plugin_list',
    'Mtc\Plugins\GridManager\Http\Controllers\GridManager::adminRenderGrid'
);

// Add grid structure data to pagedata.
HooksAdapter::add_action(
    'Pagedata/parseGetPageList',
    'Mtc\Plugins\GridManager\Http\Controllers\GridManager::addToPagedataArray'
);

// Save grid and correct pagedata when saving pagedata.
HooksAdapter::add_action(
    'Pagedata/save',
    'Mtc\Plugins\GridManager\Http\Controllers\GridManager::reconstructGrids'
);

// Whenever page is published, publish the correct grid version as well
HooksAdapter::add_action(
    'ContentManager/replacePageAndRelativePageId',
    'Mtc\Plugins\GridManager\Http\Controllers\GridManager::replacePageAndRelativePageId'
);
app()->twig->addFunction(
    new TwigFunction('gridManager', function () {
        return GridManager::getInstance();
    })
);
$twig->addFunction(
    new TwigFunction('renderGrid', function ($id) use ($twig) {
        return GridManager::renderGrid($id, $twig);
    })
);
