## Grid Manager Plugin 😎
The Grid Manager plugin provides a user interface for managing grid configurations in the application. It allows users to create, edit, and delete grid settings, making it easier to customize the layout and behavior of grids within the application. It uses a similar approach to the Wordpress gutenberg editor, providing a block-based interface for grid management.

### Features 🚀
- **Create Grids**: Users can create new grids with custom configurations.
- **Edit Grids**: Existing grids can be modified to change their settings or layout.
- **Delete Grids**: Users can remove grids that are no longer needed.
- **Block-Based Interface**: The plugin uses a block-based approach similar to the Wordpress gutenberg editor, allowing for intuitive grid management.
- **Customizable Settings**: Users can customize various settings for each grid, including layout, columns, and styles.


### Installation 🙈
This plugin can be installed in two ways, either using Docker or using a VCS server. Follow the steps below based on your setup.
#### Docker Setup Steps
1. Download the Grid Manager plugin from the repository [Pharmacy starter > Plugins > GridManager](https://bitbucket.org/mtcmedia/pharmacy-system-starter/src/master/plugins/).
2. Run the following command to ensure you are inside the container:
    ```bash
    docker exec -it <container_name> bash
    ```
3. Run the migration command to ensure the database is updated with the necessary tables and fields for the plugin:
   ```bash
   // run migration command
   php artisan migrate
   
   // clear cache
   php artisan optimize:clear
   ```
4. Make sure these packages are added to your npm package.json and run npm install
   ```json
    "dependencies": {
        "@fortawesome/fontawesome-pro": "^6.7.2",
        "@fortawesome/fontawesome-svg-core": "^6.7.2",
        "@fortawesome/pro-regular-svg-icons": "^6.7.2",
        "@fortawesome/free-brands-svg-icons": "^6.7.2",
        "@fortawesome/vue-fontawesome": "^2.0.10",
        "@fourwaves/tiptap-extension-vimeo": "^1.0.2",
        "@tiptap/extension-blockquote": "^2.0.0-beta.31",
        "@tiptap/extension-bubble-menu": "^2.0.0-beta.199",
        "@tiptap/extension-image": "^2.1.12",
        "@tiptap/extension-link": "^2.0.0-beta.199",
        "@tiptap/extension-text-align": "^2.0.0-beta.31",
        "@tiptap/extension-underline": "^2.0.0-beta.25",
        "@tiptap/extension-youtube": "^2.0.0-beta.199",
        "@tiptap/starter-kit": "^2.0.0-beta.191",
        "@tiptap/vue-2": "^2.0.0-beta.84",
        "vue-draggable-plus": "^0.6.0",
        "vue-sweetalert2": "^5.0.11",
    }
   ```
5. Add the provider to your `config/app.php` file:
   ```php
   'providers' => [
       // Other providers...
       GridServiceProvider::class,
   ],
   ```
6. Extract the plugin files to your application’s plugins directory. Loader will automatically install the plugin.

#### VCS Server Steps 
1. Download the Grid Manager plugin from the repository [Pharmacy starter > Plugins > GridManager](https://bitbucket.org/mtcmedia/pharmacy-system-starter/src/master/plugins/) and place it in the plugins directory.

3. Run the migration command to ensure the database is updated with the necessary tables and fields for the plugin:
   ```bash
   // run migration command
   php artisan migrate
   
   // clear cache
   php artisan optimize:clear
   ```
4. Make sure these packages are added to your npm package.json and run npm install
   ```json
    "dependencies": {
        "@fortawesome/fontawesome-pro": "^6.7.2",
        "@fortawesome/fontawesome-svg-core": "^6.7.2",
        "@fortawesome/pro-regular-svg-icons": "^6.7.2",
        "@fortawesome/free-brands-svg-icons": "^6.7.2",
        "@fortawesome/vue-fontawesome": "^2.0.10",
        "@fourwaves/tiptap-extension-vimeo": "^1.0.2",
        "@tiptap/extension-blockquote": "^2.0.0-beta.31",
        "@tiptap/extension-bubble-menu": "^2.0.0-beta.199",
        "@tiptap/extension-image": "^2.1.12",
        "@tiptap/extension-link": "^2.0.0-beta.199",
        "@tiptap/extension-text-align": "^2.0.0-beta.31",
        "@tiptap/extension-underline": "^2.0.0-beta.25",
        "@tiptap/extension-youtube": "^2.0.0-beta.199",
        "@tiptap/starter-kit": "^2.0.0-beta.191",
        "@tiptap/vue-2": "^2.0.0-beta.84",
        "vue-draggable-plus": "^0.6.0",
        "vue-sweetalert2": "^5.0.11",
   "@mtcmedia/vue-collapsible": "^2.0.1",
        "@mtcmedia/vue-tabs-accordion": "^3.0.1",
    }
   ```
5. Add the provider to your `config/app.php` file:
   ```php
   'providers' => [
       // Other providers...
       GridServiceProvider::class,
   ],
   ```
6. Extract the plugin files to your application’s plugins directory. Loader will automatically install the plugin.


### Admin Steps
1. Navigate to the admin area.
2. Go to Manage pages.
3. Select the page where you want to add the grid.
4. Make sure you have selected MTC view.
5. Click on the add page data.
6. Select the Grid Manager from the list.
7. Give it a name and save it.
8. Then You will find a button called Open Grid Manager, click on it to open the grid management interface.
9. It will open a new interface where you can create, edit, and delete grids.
10. To start drag and drop a row block to the grid area. from the left sidebar.
11. Right sidebar is to view the structure of the grid and to delete blocks.
12. Inside rows you can add grid blocks.
13. There can be multiple rows and each row can have multiple blocks.
14. Inside blocks you can add elements like content, images, videos, etc.
15. blocks can have multiple elements.
16. To customize a block or a row click on the settings icon in the top.
17. Each row will be assigned a class called `.gridRow` which will be given 
```css
display: grid;
grid-template-rows: auto;
align-items: center;
``` 
by default. You can customize it further in your CSS.
18. Each block will be assigned a class called `.gridRow__block`
19. In settings of the row you can set the column percentage as follows,
 - `100%` for full width,
 - `50%` for half width,
 - `25%` for quarter width, etc.
20. You can add classes to the rows and blocks using the settings panel.
21. To add more classes you should navigate to `plugins/GridManager/admin/class-manager.php` and add your custom classes.
22. Once you are done with the grid, click on the save button to save the grid configuration.
### Frontend Compiler Integration 🔧
The Grid Manager plugin can be integrated into the frontend of your application in two ways, depending on your compiler.
#### Vite
1. Open your `vite.config.js` file.
2. Download `grid_admin.js` and `grid_admin.css` file from [sites/default/js/](https://bitbucket.org/mtcmedia/pharmacy-system-starter/src/master/sites/default/js/) and [sites/default/css/](https://bitbucket.org/mtcmedia/pharmacy-system-starter/src/master/sites/default/css/) place it in your site specific js directory, e.g., `sites/{yoursite}/js/grid_admin.js`.
3. Add the following in vite.config.js
   ```js
   rollupOptions: {
                input: {
                    app: resolve(__dirname, 'sites/default/js/app.js'),
                    style: resolve(__dirname, 'sites/default/css/app.less'),
                    gridAdminStyle: resolve(__dirname, 'sites/default/css/grid_admin.less'),
                    gridAdminJs: resolve(__dirname, 'sites/default/js/grid_admin.js')
                }
            }
   ```
4. Run the following command to compile the assets:
   ```bash
    npm run build
    npm run dev

#### Webpack
1. Open your `webpack.mix.js` file.
2. Download `grid_admin.js` and `grid_admin.css` file from [sites/default/js/](https://bitbucket.org/mtcmedia/pharmacy-system-starter/src/master/sites/default/js/) and [sites/default/css/](https://bitbucket.org/mtcmedia/pharmacy-system-starter/src/master/sites/default/css/) place it in your site specific js directory, e.g., `sites/{yoursite}/js/grid_admin.js`.
3. Add the following line to include the grid manager admin styles:
   ```js
   .less(`plugins/GridManager/admin/styles/grid_admin.less`, 'public/css');
   .js(`sites/${site.name}/js/grid_admin.js`, 'public/js')
   ```
4. Run the following command to compile the assets:
   ```bash
    npm run dev
    ```
#### Frontend steps
1. Navigate to the controller of the specific twig file where you want to display the grid.
2. Add the following code to fetch the grid id:
   ```php
   if ($p->id !== null) {
    $grid = GridManager::getGridByType('cms', $p->id);
    $twig->addGlobal('grid', $grid);
   }
   ```
3. In your twig file, you can render the grid using:
   ```twig
   {% if grid.id > 0 %}
            {{ renderGrid(grid.id) }}
   {% endif %}
   ```
4. Add the less file into the includes.less which is located at `plugins/GridManager/templates/frontend/styles/grid.less`:
   ```less
   @import "plugins/GridManager/templates/frontend/styles/grid.less";
   ```
5. Add the following components to your app.js file:
    ```js
    // Grid Manager
    import Carousel from "../../../plugins/GridManager/templates/frontend/components/Carousel.vue";
    Vue.component("grid-manager-carousel", Carousel);
    
    import Gallery from "../../../plugins/GridManager/templates/frontend/components/Gallery.vue";
    Vue.component("grid-manager-gallery", Gallery);
    
    import MtcTabsAccordion from '@mtcmedia/vue-tabs-accordion'
    import MtcCollapsible from '@mtcmedia/vue-collapsible'
    
    Vue.component('mtc-tabs', MtcTabsAccordion)
    Vue.component('mtc-collapsible', MtcCollapsible)
   ```

### Workflow 🤖
1. Routes [Laravel 11 Routes](https://laravel.com/docs/11.x/routing)

- `route/api.php` -  This file contains the API routes for the Grid Manager plugin.

2. Controllers [Laravel 11 Controllers](https://laravel.com/docs/11.x/controllers)
- `Http/Controllers/GridConstructorController.php` - This controller handles the logic for creating, editing, and deleting grids.
- `Http/Controllers/GridCssClassController.php` - This controller manages the CSS classes for the grid blocks and rows.
- `Http/Controllers/GridGlobalBlocksController.php` - This controller handles the global blocks that can be used across different grids.
- `Http/Controllers/GridGlobalRowsController.php` - This controller handles the global rows that can be used across different grids.

3. Models [Laravel 11 Models](https://laravel.com/docs/11.x/eloquent)
- `Models/Grid.php` - This model represents the grid configuration and interacts with the database to store and retrieve grid data.
- `Models/GridStructures.php` - This model represents the structure of the grid, including rows, blocks and elements.
- `Models/GlobalBlocks.php` - This model represents the global blocks that can be used across different grids.
- `Models/GlobalRows.php` - This model represents the global rows that can be used across different grids.
- `Models/GridCssClass.php` - This model represents the CSS classes that can be applied to grid blocks and rows.

4. Providers [Laravel 11 Service Providers](https://laravel.com/docs/11.x/providers)
- `Providers/GridServiceProvider.php` - This service provider registers the Grid Manager plugin and its dependencies.

5. Classes
- `Classes/GridManager.php` - This class contains the main logic for bringing the grids to the frontend.

6. Views
- `templates/` - This directory contains the views for the Grid Manager plugin, including the grid management interface and the grid rendering templates.

7. Admin
- `admin/` - This directory contains the admin interface for managing grids, including the class manager and the grid management interface.

8. Migrations [Laravel 11 Migrations](https://laravel.com/docs/11.x/migrations)
- `migrations/` - This directory contains the migration files for creating the necessary database tables for the Grid Manager plugin.

### Acknowledgements 🧑‍💻
- Version: 2.0.0
- created by: MTC Team
- Author: Nithika Senaweera - nithika.senaweera@mtc.co.uk
- Contributors: Kieran Mcburney, Efraim Zakaris, Jindrich Prkop and MTC Team.
