<?php

/**
 * @author Nithika Senaweera <nithika.senaweera@mtc.co.uk>
 * @copyright 2025 mtc. http://www.mtcmedia.co.uk/
 * @version 2.0
 * @description api routes for GridManager admin. This file contains the API routes for the GridManager plugin's admin section to handle the gutenberg.
 * */

use Illuminate\Support\Facades\Route;
use Mtc\Plugins\GridManager\Http\Controllers\GridConstructorController;
use Mtc\Plugins\GridManager\Http\Controllers\GridCssClassController;
use Mtc\Plugins\GridManager\Http\Controllers\GridGlobalBlocksController;
use Mtc\Plugins\GridManager\Http\Controllers\GridGlobalRowsController;

Route::group(['middleware' => 'auth'], function() {
    // Register the API route for the grid manager
    Route::get('grid-manager', [GridConstructorController::class, 'index'])
         ->name('grid-manager.index');
    Route::post('/grid-manager/save', [GridConstructorController::class, 'save'])
         ->name('grid-manager.save');
    Route::post('/grid-manager/get', [GridConstructorController::class, 'get'])
         ->name('grid-manager.get');
    Route::delete('/grid-manager/delete', [GridConstructorController::class, 'delete'])
         ->name('grid-manager.delete');
    Route::get('/grid-manager/admin', [GridConstructorController::class, 'isMtcAdmin'])
         ->name('grid-manager.admin');

    // Register the API route for global rows
    Route::get('grid-rows', [GridGlobalRowsController::class, 'index'])
         ->name('grid-rows.index');
    Route::get('/grid-rows/all', [GridGlobalRowsController::class, 'all'])
         ->name('grid-rows.all');
    Route::get('/grid-rows/get', [GridGlobalRowsController::class, 'getById'])
         ->name('grid-rows.getById');
    Route::post('/grid-rows/save', [GridGlobalRowsController::class, 'store'])
         ->name('grid-rows.save');
    Route::delete('/grid-rows/delete', [GridGlobalRowsController::class, 'delete'])
         ->name('grid-rows.delete');
    Route::post('/grid-rows/update', [GridGlobalRowsController::class, 'update'])
         ->name('grid-rows.update');

    // Register the API route for global blocks
    Route::get('grid-blocks', [GridGlobalBlocksController::class, 'index'])
         ->name('grid-blocks.index');
    Route::post('/grid-blocks/save', [GridGlobalBlocksController::class, 'store'])
            ->name('grid-blocks.save');
    Route::get('/grid-blocks/all', [GridGlobalBlocksController::class, 'all'])
            ->name('grid-blocks.all');
    Route::delete('/grid-blocks/delete', [GridGlobalBlocksController::class, 'delete'])
            ->name('grid-blocks.delete');
    Route::post('/grid-blocks/update', [GridGlobalBlocksController::class, 'update'])
            ->name('grid-blocks.update');

    // Register the API route for grid css class
    Route::get('grid-css-class', [GridCssClassController::class, 'index'])
         ->name('grid-css-class.index');
    Route::post('/grid-css-class/save', [GridCssClassController::class, 'store'])
         ->name('grid-css-class.save');
    Route::get('/grid-css-class/get', [GridCssClassController::class, 'all'])
            ->name('grid-css-class.get');
    Route::delete('/grid-css-class/delete', [GridCssClassController::class, 'delete'])
            ->name('grid-css-class.delete');
    Route::post('/grid-css-class/update', [GridCssClassController::class, 'update'])
            ->name('grid-css-class.update');
});

?>
