<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('wisebee_consultations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('wisebee_id')->index();
            $table->unsignedBigInteger('wisebee_user_id')->nullable();
            $table->unsignedBigInteger('wisebee_created_by_id')->nullable();
            $table->unsignedBigInteger('item_id');
            $table->string('status')->index();
            $table->string('public_key');
            $table->text('comments')->nullable();
            $table->date('consultation_date');
            $table->dateTime('time_from');
            $table->dateTime('time_to');
            $table->decimal('cost')->default('0');
            $table->smallInteger('length');
            $table->smallInteger('cooldown');
            $table->string('specialist');
            $table->string('specialty');
            $table->boolean('added_to_basket')->default(false);
            $table->timestamps();
        });

        Schema::create('wisebee_documents', function (Blueprint $table) {
            $table->id()->index();
            $table->unsignedBigInteger('wisebee_id')->index();
            $table->unsignedBigInteger('consultation_id')->nullable();
            $table->unsignedBigInteger('documentable_id')->index();
            $table->string('documentable_type');
            $table->string('title')->nullable();
            $table->string('status');
            $table->string('file');
            $table->mediumText('pages');
            $table->timestamps();
        });

        Schema::create('wisebee_members', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('wisebee_id')->index();
            $table->unsignedBigInteger('member_id')->index();
            $table->string('wisebee_token')->nullable();
            $table->timestamps();
        });

        Schema::create('wisebee_notes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('wisebee_id')->index();
            $table->unsignedBigInteger('member_note_id');
            $table->timestamps();
        });

        Schema::create('wisebee_users', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('wisebee_id')->index();
            $table->unsignedBigInteger('admin_user_id');
            $table->timestamps();
        });

        Schema::table('basket_items', function (Blueprint $table) {
            $table->string('size', 255)->change();
        });

        Schema::create('wisebee_participants', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('wisebee_id')->index();
            $table->unsignedBigInteger('wisebee_consultation_id')->index();
            $table->unsignedBigInteger('wisebee_user_id')->nullable();
            $table->string('status');
            $table->string('email');
            $table->string('firstname');
            $table->string('lastname');
            $table->string('type')->index();
            $table->string('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('wisebee_consultations');
        Schema::dropIfExists('wisebee_documents');
        Schema::dropIfExists('wisebee_members');
        Schema::dropIfExists('wisebee_notes');
        Schema::dropIfExists('wisebee_users');
        Schema::dropIfExists('wisebee_participants');
    }
};
