<?php

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$ids = trim($_REQUEST['id'], ',');

$seperated_ids = explode(',', $ids);

?>

<script type="text/javascript">
window.onload = function () {
    window.print();
}
</script>

<link rel="stylesheet" type="text/css" href="/shop/admin/css/print_order.css" />

<?php

foreach ($seperated_ids as $id) {

    $basket = new Order($id);
    $order = &$basket;
    ?>

    <header>

        <div class="customHeaderDetails">

            <ul>
                <?php
                if (!empty(config('site.phone_number'))) {
                ?>
                <li>
                    <?= config('site.phone_number') ?>
                </li>
                <?php
                }

                if (defined('SITE_URL') && SITE_URL != '') {
                ?>
                <li>
                    <?= SITE_URL ?>
                </li>
                <?php
                }

                ?>
                <li>
                   <?= config('site.contact_email') ?>
                </li>
            </ul>

        </div> <!-- .customHeaderDetails -->

        <div class="logo">
            <img src="<?= THEME_PATH ?>/images/logo.png" alt="<?= config('app.name') ?>" />
        </div>

        <table class="orderSummaryDetails">
            <tr>
                <th>Order No:</th>
                <td>
                    <strong>
                        <?= $order->order_ref ?>
                    </strong>
                </td>
            </tr>
            <tr>
                <th>
                    Purchase Date:
                </th>
                <td>
                    <?= $order->getOrderDate('d/m/Y') ?>
                </td>
            </tr>
            <tr>
                <th>
                    Purchase Time:
                </th>
                <td>
                    <?= $order->getOrderDate('H:i:s') ?>
                </td>
            </tr>
            <tr>
                <th>Shipping Service:</th>
                <td><?=clean_page($order->getDelivery()->name) ?></td>
            </tr>
        </table>

    </header>

    <table>
        <tr>
            <td class="clientDetails">
                <h3>Shipping Address</h3>
                <?php
                require $path . 'shop/checkout/templates/basket.shipping.php';
                ?>
            </td>
            <td class="clientDetails">
                <h3>Billing Address</h3>
                <?php
                require $path . 'shop/checkout/templates/basket.billing.php';
                ?>
            </td>
        </tr>
    </table>

    <br/>
    <br/>

    <?php
        require $path . 'shop/admin/orders/templates/order.basket.view.php';
    ?>

    <table>
        <tr>
            <td valign="top">
            <?php
            if (!empty($basket->coupon_code)) {
                ?>
                <h2>Coupon Code</h2>
                <table>
                    <tr>
                        <td class="fieldname">Code Used</td>
                        <td><?= $basket->coupon_code ?></td>
                    </tr>
                    <tr>
                        <td class="fieldname">Free Delivery</td>
                        <td>
                            <?php
                            if ($basket->coupon_freedelivery) {
                                echo "Yes";
                            } else {
                                echo "No";
                            }
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="fieldname">Amount Deducted</td>
                        <td>
                            <?php
                            if ($basket->coupon_deduct > 0) {
                                printf("%.2f", $basket->coupon_deduct);
                            } else {
                                echo "None";
                            }
                            ?>
                        </td>
                    </tr>
                </table>
                <?php
            }
            ?>
            </td>
        </tr>
    </table>

    <div style="page-break-before: always;"></div>

<?php
}
