import Vue from 'vue';
import VueSweetalert2 from 'vue-sweetalert2';
import 'sweetalert2/dist/sweetalert2.min.css';


import grid_main from '../../../plugins/GridManager/admin/js/components/grid_main.vue';
import classesManager from "../../../plugins/GridManager/admin/js/components/ClassesManager.vue";

import RowComponent from '../../../plugins/GridManager/admin/js/components/items/RowComponent.vue';

import { library } from '@fortawesome/fontawesome-svg-core';
import { FontAwesomeIcon } from '@fortawesome/vue-fontawesome';

/* import specific icons */
import { faMagnifyingGlass } from '@fortawesome/pro-regular-svg-icons/faMagnifyingGlass';
import {faCloud} from "@fortawesome/pro-regular-svg-icons/faCloud";
import {faRefresh} from "@fortawesome/pro-regular-svg-icons/faRefresh";
import {faTrash} from "@fortawesome/pro-regular-svg-icons/faTrash";
import {faTimes} from "@fortawesome/pro-regular-svg-icons/faTimes";
import {faDiamonds4} from "@fortawesome/pro-regular-svg-icons/faDiamonds4";
import {faChevronUp} from "@fortawesome/pro-regular-svg-icons/faChevronUp";
import {faChevronDown} from "@fortawesome/pro-regular-svg-icons/faChevronDown";
import {faGear} from "@fortawesome/pro-regular-svg-icons/faGear";
import {faTableRows} from "@fortawesome/pro-regular-svg-icons/faTableRows";
import {faCube} from "@fortawesome/pro-regular-svg-icons/faCube";
import {faFolderTree} from "@fortawesome/pro-regular-svg-icons/faFolderTree";
import {faBold} from "@fortawesome/pro-regular-svg-icons/faBold";
import {faUnderline} from "@fortawesome/pro-regular-svg-icons/faUnderline";
import {faAlignCenter} from "@fortawesome/pro-regular-svg-icons/faAlignCenter";
import {faAlignLeft} from "@fortawesome/pro-regular-svg-icons/faAlignLeft";
import {faStrikethrough} from "@fortawesome/pro-regular-svg-icons/faStrikethrough";
import {faAlignRight} from "@fortawesome/pro-regular-svg-icons/faAlignRight";
import {faItalic} from "@fortawesome/pro-regular-svg-icons/faItalic";
import {faHorizontalRule} from "@fortawesome/pro-regular-svg-icons/faHorizontalRule";
import {faBlockQuote} from "@fortawesome/pro-regular-svg-icons/faBlockQuote";
import {faList} from "@fortawesome/pro-regular-svg-icons/faList";
import {faListOl} from "@fortawesome/pro-regular-svg-icons/faListOl";
import {faLink} from "@fortawesome/pro-regular-svg-icons/faLink";
import {faVimeo} from "@fortawesome/free-brands-svg-icons/faVimeo";
import {faYoutube} from "@fortawesome/free-brands-svg-icons/faYoutube";
import {faPlus} from "@fortawesome/pro-regular-svg-icons/faPlus";
import {faSave} from "@fortawesome/pro-regular-svg-icons/faSave";
import SidebarRow from "../../../plugins/GridManager/admin/js/components/items/components/structure_bar/SidebarRow.vue";
import {faChevronRight} from "@fortawesome/pro-regular-svg-icons/faChevronRight";
import {faImage} from "@fortawesome/pro-regular-svg-icons/faImage";
import {faLeftFromBracket} from "@fortawesome/pro-regular-svg-icons/faLeftFromBracket";


library.add(
    faCloud,
    faMagnifyingGlass,
    faRefresh,
    faTrash,
    faTimes,
    faDiamonds4,
    faChevronUp,
    faChevronDown,
    faChevronRight,
    faGear,
    faTableRows,
    faCube,
    faFolderTree,
    faBold,
    faUnderline,
    faAlignCenter,
    faAlignLeft,
    faAlignRight,
    faStrikethrough,
    faItalic,
    faHorizontalRule,
    faBlockQuote,
    faList,
    faListOl,
    faLink,
    faVimeo,
    faYoutube,
    faPlus,
    faSave,
    faImage,
    faLeftFromBracket
);
Vue.component('font-awesome-icon', FontAwesomeIcon);

Vue.component('grid-main', grid_main);
Vue.component('row-component', RowComponent);
Vue.component('classes-manager', classesManager);
Vue.component('sidebar-row-component', SidebarRow);
Vue.use(VueSweetalert2);

window.Vue = Vue;
window.vue_environment = new Vue({
    el: '#grid_vue_environment'
});
