<?php


use Mtc\Plugins\GridManager\Http\Controllers\GridManager;
use Mtc\Shop\Category;

$faqs_items = $p->pagedata['FAQs'];

$faqs_clean = [];

foreach($faqs_items as $faq) {

    $clean = [];
    $clean['question'] = $faq['Question']['value'];
    $clean['answer'] = $faq['Answer']['value'];
    $faqs_clean[] = $clean;
}

$categories = Category::query()
    ->with('children')
    ->where('sub_id', 0)
    ->where('hide', 0)
    ->where('is_online_doctor', 1)
    ->orderBy('order')
    ->get()
    ->map(function (Category $category) {
        $category->children = $category->children
            ->map(function (Category $subCategory) {
                $subCategory->url = $subCategory->getUrl();
                return $subCategory;
            })
            ->reject(function (Category $subCategory) {
                return $subCategory->hide == '1';
            });
        return $category;
    });

if ($p->id !== null) {
    $grid = GridManager::getGridByType('cms', $p->id);
    $twig->addGlobal('grid', $grid);
}

$twig->addGlobal('faqs', $faqs_clean);
$twig->addGlobal('homeCategories', $categories);
