# Component Registry API Contract

## GET /api/components
Retrieve list of all discoverable Twig components with metadata.

**Request:**
```
GET /api/components
Accept: application/json
```

**Query Parameters:**
- `category` (optional): Filter by category slug
- `search` (optional): Search in component names and descriptions
- `limit` (optional): Limit results (default: 50, max: 200)
- `page` (optional): Page number for pagination (default: 1)

**Response (200 OK):**
```json
{
  "data": [
    {
      "name": "Newsletter Form",
      "filename": "newsletter_form.twig",
      "path": "pages/newsletter/newsletter_form.twig",
      "category": "pages/newsletter",
      "description": "Newsletter subscription form component for email collection",
      "is_renderable": true,
      "file_size": 2048,
      "modified_at": "2025-01-27T10:30:00Z"
    }
  ],
  "meta": {
    "total": 45,
    "per_page": 50,
    "current_page": 1,
    "last_page": 1
  },
  "categories": [
    {
      "name": "Pages",
      "slug": "pages",
      "component_count": 15
    },
    {
      "name": "Forms",
      "slug": "forms",
      "component_count": 8
    }
  ]
}
```

**Error Response (500):**
```json
{
  "error": "Failed to scan component directory",
  "details": "Permission denied accessing sites/default/templates/includes/"
}
```

## GET /api/components/{path}
Retrieve detailed information about a specific component including sample data.

**Request:**
```
GET /api/components/pages/newsletter/newsletter_form.twig
Accept: application/json
```

**Response (200 OK):**
```json
{
  "component": {
    "name": "Newsletter Form",
    "filename": "newsletter_form.twig",
    "path": "pages/newsletter/newsletter_form.twig",
    "category": "pages/newsletter",
    "description": "Newsletter subscription form component for email collection",
    "is_renderable": true,
    "file_size": 2048,
    "modified_at": "2025-01-27T10:30:00Z"
  },
  "sample_data": {
    "form_action": "/newsletter/subscribe",
    "placeholder_text": "Enter your email address",
    "button_text": "Subscribe",
    "user": {
      "email": "user@example.com"
    }
  },
  "usage": {
    "include_example": "{% include 'includes/pages/newsletter/newsletter_form.twig' with { form_action: '/newsletter/subscribe', placeholder_text: 'Enter email' } %}",
    "required_variables": ["form_action"],
    "optional_variables": ["placeholder_text", "button_text", "user"]
  }
}
```

**Error Response (404):**
```json
{
  "error": "Component not found",
  "path": "pages/newsletter/invalid.twig"
}
```

## GET /components/{path}/preview
Render component in isolation for preview (HTML response).

**Request:**
```
GET /components/pages/newsletter/newsletter_form.twig/preview
Accept: text/html
```

**Response (200 OK):**
```html
<!DOCTYPE html>
<html>
<head>
    <title>Component Preview: Newsletter Form</title>
    <link href="/public/build/app.css" rel="stylesheet">
</head>
<body>
    <div class="component-preview">
        <div class="component-info">
            <h1>Newsletter Form</h1>
            <p>Newsletter subscription form component for email collection</p>

            <h2>Usage</h2>
            <pre><code>{% include 'includes/pages/newsletter/newsletter_form.twig' with { form_action: '/newsletter/subscribe' } %}</code></pre>
        </div>

        <div class="component-output">
            <!-- Rendered Twig component output here -->
            <form action="/newsletter/subscribe" method="post">
                <input type="email" placeholder="Enter your email address" required>
                <button type="submit">Subscribe</button>
            </form>
        </div>
    </div>
    <script src="/public/build/app.js"></script>
</body>
</html>
```

**Error Response (500):**
```html
<!DOCTYPE html>
<html>
<head>
    <title>Component Preview Error</title>
</head>
<body>
    <div class="component-error">
        <h1>Rendering Error</h1>
        <p><strong>Component:</strong> pages/newsletter/newsletter_form.twig</p>
        <p><strong>Error:</strong> Undefined variable "required_field" in template</p>
        <pre><code>Twig\Error\RuntimeException: Variable "required_field" does not exist.
        at sites/default/templates/includes/pages/newsletter/newsletter_form.twig:15</code></pre>
    </div>
</body>
</html>
```

## Contract Validation Rules

### Component Path Format
- Must be relative path from `sites/default/templates/includes/`
- Must end with `.twig` extension
- Must contain only alphanumeric characters, hyphens, underscores, and forward slashes
- Maximum length: 255 characters

### API Response Requirements
- All timestamps in ISO 8601 format with timezone
- File sizes in bytes as integers
- Boolean fields as true/false (not 1/0)
- Error responses include specific error details for debugging (per specification)
- HTML preview responses include full CSS/JS assets for complete component rendering

### Performance Requirements
- API endpoints must respond within 5 seconds (per NFR-001)
- Component list endpoint supports pagination for 50-200 component scale
- Preview endpoint includes caching headers for rendered output