<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class ComponentPreviewTest extends TestCase
{
    /**
     * Test GET /components/{path}/preview returns HTML preview
     */
    public function test_get_component_preview_returns_html()
    {
        $componentPath = 'pages/newsletter/newsletter_form.twig';
        $response = $this->get('/components/' . $componentPath . '/preview');

        $response->assertStatus(200)
                 ->assertHeader('Content-Type', 'text/html; charset=UTF-8');

        // Check for expected HTML structure
        $content = $response->getContent();
        $this->assertStringContains('<!DOCTYPE html>', $content);
        $this->assertStringContains('Component Preview:', $content);
        $this->assertStringContains('component-preview', $content);
    }

    /**
     * Test component preview includes required assets
     */
    public function test_component_preview_includes_assets()
    {
        $componentPath = 'pages/newsletter/newsletter_form.twig';
        $response = $this->get('/components/' . $componentPath . '/preview');

        $content = $response->getContent();
        $this->assertStringContains('app.css', $content);
        $this->assertStringContains('app.js', $content);
    }

    /**
     * Test component preview displays usage instructions
     */
    public function test_component_preview_displays_usage()
    {
        $componentPath = 'pages/newsletter/newsletter_form.twig';
        $response = $this->get('/components/' . $componentPath . '/preview');

        $content = $response->getContent();
        $this->assertStringContains('Usage', $content);
        $this->assertStringContains('{% include', $content);
    }

    /**
     * Test component preview handles rendering errors
     */
    public function test_component_preview_handles_rendering_errors()
    {
        $brokenComponentPath = 'broken/component.twig';
        $response = $this->get('/components/' . $brokenComponentPath . '/preview');

        // Should handle error gracefully, either 404 or 500 with error display
        $this->assertContains($response->status(), [404, 500]);

        if ($response->status() === 500) {
            $content = $response->getContent();
            $this->assertStringContains('Rendering Error', $content);
        }
    }
}