<?php

//  -------------------------
// | Manage Listing Settings |
//  -------------------------

$cms_root_path = "../../";
require_once($cms_root_path."includes/compatibility_includer.php");

$p = new Page();
if ( isset($_GET['page_id']) && is_numeric($_GET['page_id']) ) {
	$p->Get($_GET['page_id']);
} else {
	die("Page not found.");
}

if ( !empty($_POST['default_admin_listing_order']) ) {

	$listing_page_logic = json_decode($p->logic);

	if (empty($listing_page_logic)) {
		$listing_page_logic = new stdClass();
	}

	$listing_page_logic->default_admin_listing_order = array("`order`");
	if ( isset($_POST['default_admin_listing_order']) && !empty($_POST['default_admin_listing_order']) && json_decode($_POST['default_admin_listing_order']) !== false ) {
	    $listing_page_logic->default_admin_listing_order = $_POST['default_admin_listing_order'];
	}

	$listing_page_logic->default_frontend_listing_order = array("`order`");
	if ( isset($_POST['default_frontend_listing_order']) && !empty($_POST['default_frontend_listing_order']) && json_decode($_POST['default_frontend_listing_order']) !== false ) {
	    $listing_page_logic->default_frontend_listing_order = $_POST['default_frontend_listing_order'];
	}

	$listing_page_logic->date_value = array();
	if ( isset($_POST['date_value']) && !empty($_POST['date_value']) && json_decode($_POST['date_value']) !== false ) {
	    $listing_page_logic->date_value = $_POST['date_value'];
	}

	$listing_page_logic->columns = array("`title`","`updated`");
	if ( isset($_POST['columns']) && !empty($_POST['columns']) && json_decode($_POST['columns']) !== false ) {
	    $listing_page_logic->columns = $_POST['columns'];
	}

	$listing_page_logic->filter = array();
	if ( isset($_POST['filter']) && !empty($_POST['filter']) && json_decode($_POST['filter']) !== false ) {
	    $listing_page_logic->filter = $_POST['filter'];
	}

	$listing_page_logic->limits = array(20,50,0);
	if ( isset($_POST['limits']) && !empty($_POST['limits']) && json_decode($_POST['limits']) !== false ) {
	    $listing_page_logic->limits = $_POST['limits'];
	}

	if ( isset($_POST['ordering_enabled']) ) {
	    $listing_page_logic->ordering_enabled = $_POST['ordering_enabled'];
	}

	if ( isset($_POST['quick_search_enabled']) ) {
	    $listing_page_logic->quick_search_enabled = $_POST['quick_search_enabled'];
	}

	if ( isset($_POST['sorting_enabled']) ) {
	    $listing_page_logic->sorting_enabled = $_POST['sorting_enabled'];
	}

	if ( isset($_POST['date_filter_enabled']) ) {
	    $listing_page_logic->date_filter_enabled = $_POST['date_filter_enabled'];
	}

	if ( isset($_POST['listing_admin_info']) ) {
	    $listing_page_logic->listing_admin_info = $_POST['listing_admin_info'];
	}

	$p->logic = json_encode($listing_page_logic);
	$p->Save();

}

$page_meta['title']='Manage '.$p->title.' > Listing Settings';
include($core_root_path .'admin/templates/adminheader.full.php');

$p = new Page();
$p->Get($_GET['page_id']);
$listing_page_logic = json_decode($p->logic, true);

$default_admin_listing_order = "[\"`order`\"]";
if ( isset($listing_page_logic['default_admin_listing_order']) && !empty($listing_page_logic['default_admin_listing_order']) ) {
    $default_admin_listing_order = $listing_page_logic['default_admin_listing_order'];
}

$default_frontend_listing_order = "[\"`order`\"]";
if ( isset($listing_page_logic['default_frontend_listing_order']) && !empty($listing_page_logic['default_frontend_listing_order']) ) {
    $default_frontend_listing_order = $listing_page_logic['default_frontend_listing_order'];
}

$date_value = "[]";
if ( isset($listing_page_logic['date_value']) && !empty($listing_page_logic['date_value']) ) {
    $date_value = $listing_page_logic['date_value'];
}

$filter = "[]";
if ( isset($listing_page_logic['filter']) && !empty($listing_page_logic['filter']) ) {
    $filter = $listing_page_logic['filter'];
}

$columns = "[\"`title`\",\"`updated`\"]";
if ( isset($listing_page_logic['columns']) && !empty($listing_page_logic['columns']) ) {
    $columns = $listing_page_logic['columns'];
}

$limits = "[20,50,0]";
if ( isset($listing_page_logic['limits']) && !empty($listing_page_logic['limits']) ) {
    $limits = $listing_page_logic['limits'];
}

$ordering_enabled = 1;
if ( isset($listing_page_logic['ordering_enabled']) ) {
    $ordering_enabled = $listing_page_logic['ordering_enabled'];
}

$quick_search_enabled = 1;
if ( isset($listing_page_logic['quick_search_enabled']) ) {
    $quick_search_enabled = $listing_page_logic['quick_search_enabled'];
}

$sorting_enabled = 1;
if ( isset($listing_page_logic['sorting_enabled']) ) {
    $sorting_enabled = $listing_page_logic['sorting_enabled'];
}

$date_filter_enabled = 0;
if ( isset($listing_page_logic['date_filter_enabled']) ) {
    $date_filter_enabled = $listing_page_logic['date_filter_enabled'];
}

$listing_admin_info = "";
if ( isset($listing_page_logic['listing_admin_info']) ) {
    $listing_admin_info = $listing_page_logic['listing_admin_info'];
}

?>
<div id="listingSettings">
	<h1><?=$p->title?> Listing Settings</h1>
	<p>All of these text areas require json input. See listing class documentation/comments on the possible inputs.</p>

	<form action="" method="POST" class="el miniselector">
		<fieldset>
			<div class="row">
				<label for="default_admin_listing_order">Default admin order:</label>
				<input type="text" id="default_admin_listing_order" name="default_admin_listing_order" value="<?=clean_page(($default_admin_listing_order))?>" />
				<div class="hint el"><i class="fa fa-info-circle"></i><div class="text">What the default order of the listing in the admin area is. Should be the same as the frontend as to not confuse the user.</div></div>
			</div>
			<div class="row">
				<label for="default_frontend_listing_order">Default frontend order:</label>
				<input type="text" id="default_frontend_listing_order" name="default_frontend_listing_order" value="<?=clean_page(($default_frontend_listing_order))?>" />
				<div class="hint el"><i class="fa fa-info-circle"></i><div class="text">A value that can but is not required to be used to determine order of a listing in the frontend.</div></div>
			</div>
			<div class="row">
				<label for="sorting_enabled">Sorting enabled:</label>
				<input type="hidden" name="sorting_enabled" value="0" />
				<input type="checkbox" id="sorting_enabled" name="sorting_enabled" value="1" <?=($sorting_enabled == 1 ? "checked" : "")?> />
				<div class="hint el"><i class="fa fa-info-circle"></i><div class="text">If user is allowed to sort by columns desc &amp; asc.</div></div>
			</div>
			<div class="row">
				<label for="ordering_enabled">Ordering enabled:</label>
				<input type="hidden" name="ordering_enabled" value="0" />
				<input type="checkbox" id="ordering_enabled" name="ordering_enabled" value="1" <?=($ordering_enabled == 1 ? "checked" : "")?> />
				<div class="hint el"><i class="fa fa-info-circle"></i><div class="text">If user is allowed to order the pages here. Note - it only works if you are ordering the full list by order. And it only takes effect if in the frontend you are ordering by order and not by for example 'Date Created' pagedata.</div></div>
			</div>
			<div class="row">
				<label for="date_value">Date value:</label>
				<input type="text" id="date_value" name="date_value" value="<?=clean_page(($date_value))?>" />
				<div class="hint el"><i class="fa fa-info-circle"></i><div class="text">This is where (just like the listing class) you let the system know which pagedata or page attribute is the main date field for these listing items.</div></div>
			</div>
			<div class="row">
				<label for="date_filter_enabled">Date filter enabled:</label>
				<input type="hidden" name="date_filter_enabled" value="0" />
				<input type="checkbox" id="date_filter_enabled" name="date_filter_enabled" value="1" <?=($date_filter_enabled == 1 ? "checked" : "")?> />
				<div class="hint el"><i class="fa fa-info-circle"></i><div class="text">You need to set valid 'Date value' to enable this.</div></div>
			</div>

			<div class="row">
				<label for="quick_search_enabled">Quick search enabled:</label>
				<input type="hidden" name="quick_search_enabled" value="0" />
				<input type="checkbox" id="quick_search_enabled" name="quick_search_enabled" value="1" <?=($quick_search_enabled == 1 ? "checked" : "")?> />
			</div>
			<div class="row">
				<label for="columns">Columns:</label>
				<input type="text" id="columns" name="columns" value="<?=clean_page(($columns))?>" />
				<div class="hint el"><i class="fa fa-info-circle"></i><div class="text">Columns to be dispalyed in the admin area list.</div></div>
			</div>

			<div class="row">
				<label for="filter">Adv Filter Options:</label>
				<input type="text" id="filter" name="filter" value="<?=clean_page(($filter))?>" />
			</div>
			<div class="row">
				<label for="limits">Limits:</label>
				<input type="text" id="limits" name="limits" value="<?=clean_page(($limits))?>" />
				<div class="hint el"><i class="fa fa-info-circle"></i><div class="text">Limits select. First value is default for first-time user and 0 is no limit.</div></div>
			</div>
			<div class="row">
				<label for="listing_admin_info">Listing Admin Info:</label>
				<textarea name="listing_admin_info" id="listing_admin_info" class="tinymce"><?=clean_page($listing_admin_info)?></textarea>
				<div class="hint el"><i class="fa fa-info-circle"></i><div class="text">Text for info box.</div></div>
			</div>
			<div class="row">
				<button class="button btn" id="save" name="save" >Save</button>
			</div>
	    </fieldset>
	</form>
</div>
<?php
include($core_root_path .'admin/templates/adminfooter.full.php');
