<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class AssessmentQuestionsTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        

        \DB::table('assessment_questions')->delete();
        
        \DB::table('assessment_questions')->insert(array (
            0 => 
            array (
                'id' => 14,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'section',
                'subtype' => NULL,
                'question_text' => '<p>Your Heath</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 0,
                'is_active' => 1,
                'sort' => 0,
                'created_at' => '2025-06-25 11:27:08',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            1 => 
            array (
                'id' => 15,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'variations',
                'subtype' => NULL,
                'question_text' => '<p>What was your sex assigned at birth?</p>',
                'variations' => '["Male","Female"]',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 1,
                'created_at' => '2025-06-25 11:28:42',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            2 => 
            array (
                'id' => 16,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Do you identify as your assigned sex?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 2,
                'created_at' => '2025-06-25 13:10:30',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            3 => 
            array (
                'id' => 17,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>How do you identify your gender?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 16,
                'show_if_answer' => 'No',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 3,
                'created_at' => '2025-06-25 13:12:30',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            4 => 
            array (
                'id' => 18,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Do you need help with this form?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 0,
                'is_active' => 1,
                'sort' => 7,
                'created_at' => '2025-06-25 13:29:22',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            5 => 
            array (
                'id' => 19,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'information',
                'subtype' => NULL,
                'question_text' => '<p>If you need any help completing this form, don&rsquo;t worry &mdash; just give us a call on 01100 123123 or email info@mtcpharmacy.co.uk and we&rsquo;ll guide you through it.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 18,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 0,
                'is_active' => 1,
                'sort' => 8,
                'created_at' => '2025-06-25 13:29:53',
                'updated_at' => '2025-06-25 13:37:17',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            6 => 
            array (
                'id' => 20,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Do you have the ability to make informed decisions regarding your own healthcare?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '"No"',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '"No"',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 9,
                'created_at' => '2025-06-25 13:38:23',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            7 => 
            array (
                'id' => 21,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'alert',
                'subtype' => NULL,
                'question_text' => '<p>Sorry, we are unable to offer you this treatment, please contact your GP.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 20,
                'show_if_answer' => 'No',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 0,
                'is_active' => 1,
                'sort' => 10,
                'created_at' => '2025-06-25 13:39:19',
                'updated_at' => '2025-06-25 13:39:19',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            8 => 
            array (
                'id' => 22,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Do you currently have, or have you ever had, any of the following medical conditions or surgeries?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 11,
                'created_at' => '2025-06-25 13:49:41',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            9 => 
            array (
                'id' => 23,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'variations',
                'subtype' => NULL,
                'question_text' => '<p>Do you currently have, or have you ever had, any of the following medical conditions or surgeries? Please tick all that apply.</p>',
            'variations' => '["Kidney problems","Hormone or sugar-related conditions (e.g. diabetes, thyroid disorders)","Neurological conditions (e.g. Parkinsons, stroke, or mini-stroke\\/TIA)","Liver problems (e.g. hepatitis, fatty liver, alcohol-related liver disease)","Breathing or lung conditions (e.g. asthma, COPD, bronchiectasis)","Mental health conditions (e.g. anxiety, depression, personality disorder)","Thyroidectomy (removal of thyroid gland)","None of the above"]',
                'clearall_answer' => 'None of the above',
                'is_multiple' => 1,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 22,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 12,
                'created_at' => '2025-06-25 13:50:15',
                'updated_at' => '2025-06-26 09:53:31',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            10 => 
            array (
                'id' => 24,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please provide more details.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 23,
                'show_if_answer' => 'None of the above',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 13,
                'created_at' => '2025-06-25 13:53:21',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            11 => 
            array (
                'id' => 25,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Are you currently taking any medication? This includes prescription-only, over-the-counter and homeopathic medicines.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 14,
                'created_at' => '2025-06-25 14:15:01',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            12 => 
            array (
                'id' => 26,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please detail what medications you are currently taking.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 25,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 15,
                'created_at' => '2025-06-25 14:15:04',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            13 => 
            array (
                'id' => 27,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Do you have any allergies to medications or other substances?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 16,
                'created_at' => '2025-06-25 14:26:27',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            14 => 
            array (
                'id' => 28,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please detail further.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 27,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 17,
                'created_at' => '2025-06-25 14:26:41',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            15 => 
            array (
                'id' => 29,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Do you partake in the usage of recreational drugs?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 18,
                'created_at' => '2025-06-25 14:28:05',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            16 => 
            array (
                'id' => 30,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please list everything you use. This information is for medical purposes and will not be shared with external parties.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 29,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 19,
                'created_at' => '2025-06-25 14:28:52',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            17 => 
            array (
                'id' => 31,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'text',
                'subtype' => NULL,
                'question_text' => '',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 0,
                'is_active' => 0,
                'sort' => 31,
                'created_at' => '2025-06-25 14:29:43',
                'updated_at' => '2025-06-25 14:36:37',
                'deleted_at' => '2025-06-25 14:36:37',
                'settings' => '',
            ),
            18 => 
            array (
                'id' => 32,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'bp_readings',
                'subtype' => NULL,
                'question_text' => '<p>What is your blood pressure?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 20,
                'created_at' => '2025-06-25 14:37:22',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            19 => 
            array (
                'id' => 33,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'variations',
                'subtype' => NULL,
                'question_text' => '<p>What is your ethnicity?</p>',
                'variations' => '["English, Welsh, Scottish, Northern Irish or British","Irish","Gypsy or Irish Traveller","Roma","Any other White background","White and Black Caribbean","White and Black African","White and Asian","Any other Mixed or Multiple ethnic background","Indian","Pakistani","Bangladeshi","Chinese","Any other Asian background","Caribbean","African","Any other Black, Black British or Caribbean background","Arab","Any other ethnic group","Prefer not to say"]',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 21,
                'created_at' => '2025-06-25 14:40:31',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            20 => 
            array (
                'id' => 34,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please provide further detail.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 33,
                'show_if_answer' => 'Any other ethnic group',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 22,
                'created_at' => '2025-06-25 14:40:40',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            21 => 
            array (
                'id' => 35,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'variations',
                'subtype' => NULL,
                'question_text' => '<p>Please share your current pregnancy status.</p>',
                'variations' => '["Pregnant","Planning to become Pregnant","Breastfeeding","Not applicable"]',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '["Planning to become Pregnant"]',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 15,
                'show_if_answer' => 'Female',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 4,
                'created_at' => '2025-06-25 14:52:08',
                'updated_at' => '2025-06-26 09:51:20',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            22 => 
            array (
                'id' => 36,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>I am aware that I must stop taking any GLP-1 treatments such as Mounjaro &amp; Wegovy 8 weeks before attempting to fall pregnant.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '"No"',
                'show_if_question' => 15,
                'show_if_answer' => 'Female',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 5,
                'created_at' => '2025-06-25 15:01:00',
                'updated_at' => '2025-06-26 09:51:03',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            23 => 
            array (
                'id' => 37,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'alert',
                'subtype' => NULL,
                'question_text' => '<p>Please confirm that you acknowledge this information.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 15,
                'show_if_answer' => 'Female',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 0,
                'is_active' => 1,
                'sort' => 6,
                'created_at' => '2025-06-25 15:05:40',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            24 => 
            array (
                'id' => 38,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please provide any additional information you would like to share with us.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 0,
                'is_active' => 1,
                'sort' => 23,
                'created_at' => '2025-06-25 15:11:37',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            25 => 
            array (
                'id' => 39,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'section',
                'subtype' => NULL,
                'question_text' => '<p>Medical Questions</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 0,
                'is_active' => 1,
                'sort' => 24,
                'created_at' => '2025-06-25 16:26:39',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            26 => 
            array (
                'id' => 40,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'date',
                'subtype' => NULL,
                'question_text' => '<p>Please enter your birthdate.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 25,
                'created_at' => '2025-06-25 16:28:54',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            27 => 
            array (
                'id' => 41,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'number',
                'subtype' => NULL,
            'question_text' => '<p>What is your height (feet)?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 42,
                'show_if_answer' => 'Imperial',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 27,
                'created_at' => '2025-06-25 16:32:20',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            28 => 
            array (
                'id' => 42,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'variations',
                'subtype' => NULL,
                'question_text' => '<p>Please enter your height and weight.</p>',
                'variations' => '["Metric","Imperial"]',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 26,
                'created_at' => '2025-06-25 16:38:02',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            29 => 
            array (
                'id' => 43,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'number',
                'subtype' => NULL,
            'question_text' => '<p>What is your weight (stone/pounds)?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 42,
                'show_if_answer' => 'Imperial',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 28,
                'created_at' => '2025-06-25 16:40:12',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            30 => 
            array (
                'id' => 44,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'number',
                'subtype' => NULL,
            'question_text' => '<p>What is your height in (cm)?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 42,
                'show_if_answer' => 'Metric',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 29,
                'created_at' => '2025-06-25 16:45:44',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            31 => 
            array (
                'id' => 45,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'number',
                'subtype' => NULL,
            'question_text' => '<p>What is your weight in (kg)?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 42,
                'show_if_answer' => 'Metric',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 30,
                'created_at' => '2025-06-25 16:46:24',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            32 => 
            array (
                'id' => 46,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'number',
                'subtype' => NULL,
            'question_text' => '<p>What is your target weight (kg)? <strong>Please ensure you update your current weight above with each order.</strong></p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 31,
                'created_at' => '2025-06-25 16:51:44',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            33 => 
            array (
                'id' => 47,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'variations',
                'subtype' => NULL,
            'question_text' => '<p><strong>Are you currently using any weight loss medication? (including Mounjaro/Wegovy, purchased from ourselves or elsewhere)</strong></p>',
                'variations' => '["Mounjaro","Wegovy","Saxenda","Orlistat","Other"]',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 32,
                'created_at' => '2025-06-25 16:52:16',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            34 => 
            array (
                'id' => 48,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please provide further details.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 47,
                'show_if_answer' => 'Other',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 33,
                'created_at' => '2025-06-25 16:56:46',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            35 => 
            array (
                'id' => 49,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'variations',
                'subtype' => NULL,
                'question_text' => '<p>People with weight-related medical conditions may be prescribed weight loss medicines at a lower BMI than other patients, if suitable. Please let us know if you have any of the following weight-related conditions:</p>',
            'variations' => '["Chronic malabsorption syndrome","An eating disorder such as anorexia or bulimia","Gallstones, gallbladder or bile duct problems","Pancrease disease","An underactive or over active thyroid","Severe heart failure","Kidney impairment","Diabetic retinopathy","Pancreatitis (current or previous issue)","Gastroparesis","Any Inflammatory bowel disease such as Ulcerative Colitis or Chrohns (not IBS)","History or family history of Thyroid cancer, medullary thyroid cancer or MEN-2","Any cancer, current chemotherapy or radiotherapy","None of the above"]',
                'clearall_answer' => '',
                'is_multiple' => 1,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 34,
                'created_at' => '2025-06-25 16:59:18',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            36 => 
            array (
                'id' => 50,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'variations',
                'subtype' => NULL,
                'question_text' => '<p>Have you been diagnosed with any of the following conditions?</p>',
            'variations' => '["Chronic malabsorption syndrome","An eating disorder such as anorexia or bulimia","Gallstones, gallbladder or bile duct problems","Pancrease disease","An underactive or over active thyroid","Severe heart failure","Kidney impairment","Diabetic retinopathy","Pancreatitis (current or previous issue)","Gastroparesis","Any Inflammatory bowel disease such as Ulcerative Colitis or Chrohns (not IBS)","History or family history of Thyroid cancer, medullary thyroid cancer or MEN-2","Any cancer, current chemotherapy or radiotherapy","None of the above"]',
                'clearall_answer' => '',
                'is_multiple' => 1,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 35,
                'created_at' => '2025-06-25 17:04:37',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            37 => 
            array (
                'id' => 51,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Do you have gallbladder, gallstones or bile duct issues?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 36,
                'created_at' => '2025-06-25 17:06:00',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            38 => 
            array (
                'id' => 52,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'variations',
                'subtype' => NULL,
                'question_text' => '<p>Could you please provide more information about your gallbladder issues?</p>',
            'variations' => '["Please select an option","I am currently experiencing, or have previously experienced gallstones (cholestasis\\/cholecystitis)","I have had my gallbladder removed","Other"]',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 51,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 37,
                'created_at' => '2025-06-25 17:07:06',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            39 => 
            array (
                'id' => 53,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'number',
                'subtype' => NULL,
                'question_text' => '<p>Please provide us with how many hours of exercise you do a week.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 38,
                'created_at' => '2025-06-25 17:11:50',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            40 => 
            array (
                'id' => 54,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'variations',
                'subtype' => NULL,
                'question_text' => '<p>Which of the following surgeries or procedures did you have?</p>',
                'variations' => '["Balloon","Gastric band","Gastric bypass","Mini-gastric bypass","Sleeve gastrectomy","Other"]',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 55,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 40,
                'created_at' => '2025-06-25 17:19:22',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            41 => 
            array (
                'id' => 55,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Have you ever had bariatric weight-loss surgery or a gastric band procedure?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 39,
                'created_at' => '2025-06-25 17:21:06',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            42 => 
            array (
                'id' => 56,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'image',
                'subtype' => 'image',
                'question_text' => '<p>Please upload a full length picture of yourself</p>
<p>This image will only be visible to the medical professional providing the treatment<br />We know it is inconvenient, however we request a photo for the safety of our patients and to prevent risks in those who are vulnerable<br />&nbsp;</p>
<p><strong>Compulsory Question&nbsp;-&nbsp;Please be aware, you can still proceed with the consultation without uploading a photo, however it will delay&nbsp;us in making an informed clinical decision until this is completed when requested by our team</strong></p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 41,
                'created_at' => '2025-06-25 17:23:18',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            43 => 
            array (
                'id' => 57,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'variations',
                'subtype' => NULL,
                'question_text' => '<p>Please select the medication you plan on making an order for and confirm the relevant acknowledgements:</p>',
                'variations' => '["Please select an option","Mounjaro","Saxenda","Orlistat","Wegovy","Other"]',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 42,
                'created_at' => '2025-06-26 09:10:25',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            44 => 
            array (
                'id' => 58,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>I understand that I must accept the first delivery attempt for any temperature-controlled medications, such as Saxenda, Wegovy, or Mounjaro. Cloud Pharmacy will not be held responsible for missed deliveries or address errors.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 43,
                'created_at' => '2025-06-26 09:18:32',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            45 => 
            array (
                'id' => 59,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'section',
                'subtype' => NULL,
                'question_text' => '<p>Consent</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 0,
                'is_active' => 1,
                'sort' => 44,
                'created_at' => '2025-06-26 09:18:41',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            46 => 
            array (
                'id' => 60,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>I understand that I should only use one weight loss treatment at a time. <br />If I experience any concerning side effects, I will seek advice from a pharmacist, my GP, or another qualified healthcare professional. I confirm that I will read and follow the information provided in the Patient Information Leaflet. <br />I confirm that this treatment is for my personal use and that I consent to its use. If it does not help me achieve my weight loss goals, I will consult my GP for further advice. <br />I take responsibility for informing the pharmacy and my regular healthcare provider of any changes to my health or circumstances.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 45,
                'created_at' => '2025-06-26 09:21:43',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            47 => 
            array (
                'id' => 61,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p><br />Would you like us to notify your GP of the treatment you chose to order today?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 46,
                'created_at' => '2025-06-26 09:30:21',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            48 => 
            array (
                'id' => 62,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'notify_gp',
                'subtype' => NULL,
                'question_text' => '<p>Please provide further details:</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 61,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 47,
                'created_at' => '2025-06-26 09:30:40',
                'updated_at' => '2025-06-26 09:48:40',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            49 => 
            array (
                'id' => 63,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 6,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Do you agree to the following:</p>
<p>- You understand that the prescriber will rely on the information you have provided to make clinical decisions, and that providing inaccurate or incomplete information could put your health at risk. <br />- You are aware that your identity may be verified using a soft identity check through a third-party provider. <br />- You will read and follow the instructions provided in the Patient Information Leaflet that accompanies your treatment. <br />- You agree to the terms and conditions and privacy policy of the service provider. <br />- This treatment is intended solely for your personal use. <br />- You confirm that all the information you have provided is accurate and truthful to the best of your knowledge. <br />- You will inform your regular healthcare provider of this treatment if appropriate. <br />- You accept the terms of service related to the provision of this treatment.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 48,
                'created_at' => '2025-06-26 09:31:28',
                'updated_at' => '2025-06-26 09:52:37',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            50 => 
            array (
                'id' => 64,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 7,
                'question_type' => 'section',
                'subtype' => NULL,
                'question_text' => '<p>Allergy Assessment Form</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 0,
                'is_active' => 1,
                'sort' => 64,
                'created_at' => '2025-07-07 10:55:25',
                'updated_at' => '2025-07-07 11:39:57',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            51 => 
            array (
                'id' => 65,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 7,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Have you ever had an allergic reaction to any medication, including antibiotics, painkillers or antihistamines?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 65,
                'created_at' => '2025-07-07 11:02:12',
                'updated_at' => '2025-07-07 11:39:57',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            52 => 
            array (
                'id' => 66,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 7,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please share more information.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 65,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 66,
                'created_at' => '2025-07-07 11:02:36',
                'updated_at' => '2025-07-07 11:02:36',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            53 => 
            array (
                'id' => 67,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 7,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Have you ever experienced wheezing, shortness of breath, or asthma symptoms after taking aspirin, ibuprofen or other similar medications?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 67,
                'created_at' => '2025-07-07 11:03:04',
                'updated_at' => '2025-07-07 11:39:57',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            54 => 
            array (
                'id' => 68,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 7,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please share more information.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 67,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 68,
                'created_at' => '2025-07-07 11:03:50',
                'updated_at' => '2025-07-07 11:03:50',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            55 => 
            array (
                'id' => 69,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 7,
                'question_type' => 'yes_no',
                'subtype' => NULL,
            'question_text' => '<p>Do you have any known food, dye, or preservative allergies (e.g. lactose, gluten, soya, shellfish)?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 69,
                'created_at' => '2025-07-07 11:04:03',
                'updated_at' => '2025-07-07 11:39:57',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            56 => 
            array (
                'id' => 70,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 7,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please share more information.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 69,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 70,
                'created_at' => '2025-07-07 11:04:23',
                'updated_at' => '2025-07-07 11:39:57',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            57 => 
            array (
                'id' => 71,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 7,
                'question_type' => 'yes_no',
                'subtype' => NULL,
            'question_text' => '<p>Have you ever had a skin reaction (rash, swelling, redness) from creams or ointments such as hydrocortisone or antibiotic gels?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 71,
                'created_at' => '2025-07-07 11:04:36',
                'updated_at' => '2025-07-07 11:39:57',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            58 => 
            array (
                'id' => 72,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 7,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please share more information.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 71,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 72,
                'created_at' => '2025-07-07 11:04:46',
                'updated_at' => '2025-07-07 11:39:57',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            59 => 
            array (
                'id' => 73,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 7,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Are you currently using any antihistamines or allergy medications? If so, which ones and do they cause drowsiness?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 73,
                'created_at' => '2025-07-07 11:05:00',
                'updated_at' => '2025-07-07 11:39:57',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            60 => 
            array (
                'id' => 74,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 7,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please share more information.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 73,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 74,
                'created_at' => '2025-07-07 11:06:43',
                'updated_at' => '2025-07-07 11:39:57',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            61 => 
            array (
                'id' => 75,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 8,
                'question_type' => 'section',
                'subtype' => NULL,
                'question_text' => '<p>Existing Heart Issues</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 0,
                'is_active' => 1,
                'sort' => 75,
                'created_at' => '2025-07-07 13:53:19',
                'updated_at' => '2025-07-07 13:57:27',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            62 => 
            array (
                'id' => 76,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 8,
                'question_type' => 'yes_no',
                'subtype' => NULL,
            'question_text' => '<p>Do you currently take any medications for heart conditions, such as nitrates (e.g. GTN spray or isosorbide mononitrate)?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 76,
                'created_at' => '2025-07-07 13:53:30',
                'updated_at' => '2025-07-07 13:57:27',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            63 => 
            array (
                'id' => 77,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 8,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please add more detail.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 76,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 77,
                'created_at' => '2025-07-07 13:53:47',
                'updated_at' => '2025-07-07 13:57:27',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            64 => 
            array (
                'id' => 78,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 8,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Have you ever been diagnosed with low blood pressure, heart failure, angina, or a previous heart attack?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 78,
                'created_at' => '2025-07-07 13:54:04',
                'updated_at' => '2025-07-07 13:57:27',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            65 => 
            array (
                'id' => 79,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 8,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please add more detail.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 78,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 79,
                'created_at' => '2025-07-07 13:54:15',
                'updated_at' => '2025-07-07 13:54:15',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            66 => 
            array (
                'id' => 80,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 8,
                'question_type' => 'yes_no',
                'subtype' => NULL,
            'question_text' => '<p>Do you have an irregular heartbeat or any condition affecting your heart rhythm (e.g. arrhythmia, atrial fibrillation)?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 80,
                'created_at' => '2025-07-07 13:54:31',
                'updated_at' => '2025-07-07 13:57:27',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            67 => 
            array (
                'id' => 81,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 8,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please add more detail.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 80,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 81,
                'created_at' => '2025-07-07 13:54:57',
                'updated_at' => '2025-07-07 13:54:57',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            68 => 
            array (
                'id' => 82,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 8,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Do you currently take any beta-blockers, such as Propranolol, Bisoprolol, or Atenolol?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 82,
                'created_at' => '2025-07-07 13:55:07',
                'updated_at' => '2025-07-07 13:57:27',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            69 => 
            array (
                'id' => 83,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 8,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please add more detail.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 82,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 83,
                'created_at' => '2025-07-07 13:55:18',
                'updated_at' => '2025-07-07 13:57:02',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            70 => 
            array (
                'id' => 84,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 8,
                'question_type' => 'yes_no',
                'subtype' => NULL,
                'question_text' => '<p>Do you have any breathing conditions like asthma or COPD?</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 0,
                'show_if_answer' => '',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 84,
                'created_at' => '2025-07-07 13:56:00',
                'updated_at' => '2025-07-07 13:57:27',
                'deleted_at' => NULL,
                'settings' => '',
            ),
            71 => 
            array (
                'id' => 85,
                'magento_question_id' => NULL,
                'old_id' => 0,
                'form_id' => 8,
                'question_type' => 'textarea',
                'subtype' => NULL,
                'question_text' => '<p>Please add more detail.</p>',
                'variations' => '',
                'clearall_answer' => '',
                'is_multiple' => 0,
                'block_if' => '',
                'alert_if' => '',
                'okay_if' => '',
                'cant_proceed_if' => '',
                'show_if_question' => 84,
                'show_if_answer' => 'Yes',
                'recommended' => NULL,
                'excluded' => NULL,
                'answer_expires_after_days' => 0,
                'is_required' => 1,
                'is_active' => 1,
                'sort' => 85,
                'created_at' => '2025-07-07 13:56:51',
                'updated_at' => '2025-07-07 13:56:51',
                'deleted_at' => NULL,
                'settings' => '',
            ),
        ));
        
        
    }
}