<?php

namespace Mtc\Modules\Members\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Route;
use Mtc\Modules\Members\Classes\Auth;

class MemberAuth
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure $next
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $member = \Mtc\Modules\Members\Classes\Auth::getLoggedInMember();

        if (!$member->exists) {
            return redirect(route('members-login'));
        }

        return $next($request);
    }
}
