<?php

namespace Mtc\Modules\Members\Providers;

use Illuminate\Routing\Router;
use Illuminate\Support\ServiceProvider;
use Mtc\Modules\Members\Classes\Authenticator;
use Mtc\Modules\Members\Http\Middleware\MemberAuth;
use Mtc\Modules\Members\Models\Member;


class MembersServiceProvider extends ServiceProvider
{

    public function boot(Router $router) : void
    {
        $this->loadRoutesFrom(__DIR__ . '/../routes/members.php');
        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');
        $this->mergeConfigFrom(__DIR__ . '/../config/members.php', 'members');
        $router->middlewareGroup('members:auth', [
           MemberAuth::class,
        ]);
    }

    /**
     * Registers event listeners
     *
     * @return void
     */
    public function register(): void
    {
        $this->app->singleton(Member::class, function () {
            return app(Authenticator::class)->getLoggedInMember();
        });
    }
}
