<?php

/**
 * Class MenuEntryBuilder
 * Generates the menu entry for the new module.
 *
 * @copyright MTC media Ltd.
 * @author Rihards Silins
 *
 * @version 2 26/05/2016
 */
namespace Mtc\Modules\ModuleBuilder\Classes\Builders;

use Illuminate\Database\Capsule\Manager as Capsule;

class MenuEntryBuilder
{
    /**
     * module folder name.
     *
     * @var string
     */
    private $folder_name;
    /**
     * module model name in singular.
     *
     * @var string
     */
    private $module_name_singular;
    /**
     * module model name in plural.
     *
     * @var string
     */
    private $module_name_plural;

    /**
     * MenuEntryBuilder::setFolderName
     * Set folder name of the module to be built.
     *
     * @param string folder_name
     *
     * @return bool success
     */
    public function setFolderName($folder_name)
    {
        // validate
        if (preg_match('/^[a-z_A-Z-]+$/', $folder_name)) {
            $this->folder_name = $folder_name;

            return true;
        }

        return false;
    }

    /**
     * FileBuilder::setModuleNameSingular()
     * Set module name of the module to be built.
     *
     * @param string module_name_singular
     *
     * @return bool success
     */
    public function setModuleNameSingular($module_name_singular)
    {
        $this->module_name_singular = $module_name_singular;

        return true;
    }

    /**
     * FileBuilder::setModuleNamePlural()
     * Set module name of the module to be built.
     *
     * @param string module_name_plural
     *
     * @return bool success
     */
    public function setModuleNamePlural($module_name_plural)
    {
        $this->module_name_plural = $module_name_plural;

        return true;
    }

    /**
     * MenuEntryBuilder::build
     * Generates the database tables used in module builder modules.
     *
     * @return bool success
     */
    public function build()
    {
        if (empty($this->module_name_singular)) {
            return false;
        }

        if (empty($this->module_name_plural)) {
            return false;
        }

        if (empty($this->folder_name)) {
            return false;
        }

        $admin_menu_id = Capsule::table('admin_menu')->insertGetId(
            array(
                'sub_id' => 0,
                'title' => $this->module_name_singular,
            )
        );

        if (empty($admin_menu_id)) {
            return false;
        }

        Capsule::table('admin_menu')->insertGetId(
            array(
                'sub_id' => $admin_menu_id,
                'title' => 'Manage '.$this->module_name_plural,
                'path' => '/modules/'.$this->folder_name.'/admin/manage.php',
                'activePath' => '/modules/'.$this->folder_name.'/admin/manage',
            )
        );

        if (empty($admin_menu_id)) {
            return false;
        }

        Capsule::table('admin_menu')->insertGetId(
            array(
                'sub_id' => $admin_menu_id,
                'title' => 'Add New '.$this->module_name_singular,
                'path' => '/modules/'.$this->folder_name.'/admin/edit.php',
                'activePath' => '/modules/'.$this->folder_name.'/admin/edit',
            )
        );

        if (empty($admin_menu_id)) {
            return false;
        }

        return true;
    }
}
