<?php

use Illuminate\Support\Facades\Route;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\BpTrackController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\ConsultationController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\DashboardController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\EventLogController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\FileController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\MemberAttributeController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\MemberNoteController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\MemberOrderController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\MessageController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\PatientController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\ProductController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\ReviewController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\ReviewTypeController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\TreatmentController;
use Mtc\Plugins\Clinic\Http\Controllers\Admin\WeightTrackController;

Route::group([
    'prefix' => 'reviews',
], function () {
    Route::get('access/{hash}', [\Mtc\Plugins\Clinic\Http\Controllers\ReviewController::class, 'access'])
        ->name('reviews-access');
    Route::get('result/{hash}', [\Mtc\Plugins\Clinic\Http\Controllers\ReviewController::class, 'result'])
        ->name('reviews-result');
});

/* ADMIN */

Route::group([
    'middleware' => 'auth',
    'prefix' => 'admin',
], function () {

    Route::group([
        'prefix' => 'dashboard',
    ], function () {
        Route::get('dashboard', [DashboardController::class, 'index'])
            ->name('admin-dashboard');
    });

    Route::get('login-as/{id}', [PatientController::class, 'loginAs'])
        ->name('admin-login-as-member');

    Route::group([
        'prefix' => 'member-attributes',
    ], function () {
        Route::get('{id}', [MemberAttributeController::class, 'index'])
            ->name('admin-member-attributes');
        Route::post('load/{id}', [MemberAttributeController::class, 'load'])
            ->name('admin-member-attributes-load');
        Route::post('store/{id}', [MemberAttributeController::class, 'store'])
            ->name('admin-member-attributes-store');
    });

    Route::group([
        'prefix' => 'member-notes',
    ], function () {
        Route::post('load/{id}', [MemberNoteController::class, 'load'])
            ->name('admin-member-notes-load');
        Route::post('store/{id}', [MemberNoteController::class, 'store'])
            ->name('admin-member-notes-store');
        Route::post('load-flags/{id}', [MemberNoteController::class, 'loadFlags'])
            ->name('admin-member-notes-load-flags');
        Route::post('delete-flag/{id}', [MemberNoteController::class, 'deleteFlag'])
            ->name('admin-member-notes-delete-flag');
        Route::post('toggle-flag-status/{id}', [MemberNoteController::class, 'toggleFlagStatus'])
            ->name('admin-member-notes-toggle-flag-status');
    });

    Route::group([
        'prefix' => 'member-orders',
    ], function () {
        Route::post('load/{id}', [MemberOrderController::class, 'load'])
            ->name('admin-member-orders-load');
    });

    Route::group([
        'prefix' => 'review-types',
    ], function () {
        Route::get('index', [ReviewTypeController::class, 'index'])
            ->name('admin-review-types');
        Route::get('edit/{id?}', [ReviewTypeController::class, 'edit'])
            ->name('admin-review-types-edit');
        Route::post('store', [ReviewTypeController::class, 'store'])
            ->name('admin-review-types-store');
    });

    Route::group([
        'prefix' => 'reviews',
    ], function () {
        Route::get('index', [ReviewController::class, 'index'])
            ->name('admin-reviews');
        Route::post('load', [ReviewController::class, 'load'])
            ->name('admin-reviews-load');
        Route::post('load-review', [ReviewController::class, 'loadReview'])
            ->name('admin-reviews-load-review');
        Route::get('edit/{id?}', [ReviewController::class, 'edit'])
            ->name('admin-reviews-edit');
        Route::post('store', [ReviewController::class, 'store'])
            ->name('admin-reviews-store');
    });

    Route::group([
        'prefix' => 'treatments',
    ], function () {
        Route::post('load/{id}', [TreatmentController::class, 'load'])
            ->name('admin-patient-treatments-load');
        Route::post('store/{id}', [TreatmentController::class, 'store'])
            ->name('admin-patient-treatments-store');
        Route::post('delete/{id}', [TreatmentController::class, 'delete'])
            ->name('admin-patient-treatments-delete');
    });

    Route::group([
        'prefix' => 'bp-track',
    ], function () {
        Route::post('load/{id}', [BpTrackController::class, 'load'])
            ->name('admin-patient-bp-track-load');
        Route::post('store/{id}', [BpTrackController::class, 'store'])
            ->name('admin-patient-bp-track-store');
        Route::post('delete/{id}', [BpTrackController::class, 'delete'])
            ->name('admin-patient-bp-track-delete');
    });

    Route::group([
        'prefix' => 'weight-track',
    ], function () {
        Route::post('load/{id}', [WeightTrackController::class, 'load'])
            ->name('admin-patient-weight-track-load');
        Route::post('store/{id}', [WeightTrackController::class, 'store'])
            ->name('admin-patient-weight-track-store');
        Route::post('delete/{id}', [WeightTrackController::class, 'delete'])
            ->name('admin-patient-weight-track-delete');
    });

    Route::group([
        'prefix' => 'products',
    ], function () {
        Route::post('search', [ProductController::class, 'search'])
            ->name('admin-products-search');
    });

    Route::group([
        'prefix' => 'files',
    ], function () {
        Route::any('get/{id}', [FileController::class, 'getFile'])
            ->name('admin-file-get');
        Route::post('load/{id}', [FileController::class, 'load'])
            ->name('admin-patient-files-load');
        Route::post('store/{id}', [FileController::class, 'store'])
            ->name('admin-patient-files-store');
        Route::post('delete/{id}', [FileController::class, 'delete'])
            ->name('admin-patient-files-delete');
    });

    Route::group([
        'prefix' => 'consultations',
    ], function () {
        Route::post('load/{id}', [ConsultationController::class, 'load'])
            ->name('admin-patient-consultations-load');
    });

    Route::group([
        'prefix' => 'messages',
    ], function () {
        Route::post('load/{id}', [MessageController::class, 'load'])
            ->name('admin-patient-messages-load');
    });

    Route::group([
        'prefix' => 'event-log',
    ], function () {
        Route::post('load/{id}', [EventLogController::class, 'load'])
            ->name('admin-patient-event-log-load');
        Route::get('get-file/{id}', [EventLogController::class, 'getFile'])
            ->name('admin-patient-event-log-get-file');
    });

    Route::group([
        'prefix' => 'patients',
    ], function () {
        Route::get('/', [PatientController::class, 'index'])
            ->name('admin-patients');
        Route::get('add', [PatientController::class, 'add'])
            ->name('admin-patients-add');
        Route::post('store', [PatientController::class, 'store'])
            ->name('admin-patients-store');
        Route::post('export', [PatientController::class, 'export'])
            ->name('admin-patients-export');
        Route::get('profile/{id}', [PatientController::class, 'profile'])
            ->name('admin-patients-profile');
        Route::get('search', [PatientController::class, 'search'])
            ->name('admin-patients-search');
    });

    Route::any('/admin/patients/{id}/profile/bootstrap', [\Mtc\Plugins\Clinic\Http\Controllers\Admin\PatientProfileController::class, 'bootstrap'])
        ->name('admin-patient-profile-bootstrap');
});
