<?php
/**
 * Feefo Reviews Listing page
 *
 * @category Plugins
 * @package  Mtc_FeefoReviews
 * @author   Davis Lasis <davis.lasis@mtcmedia.co.uk>
 * @version  v3.0
 */
namespace Mtc\Plugins\FeefoReviews\Classes;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$page_meta['title'] = 'Feefo Reviews Logs';

$rowsPerPage = 25;
$pageNum = (!empty($_GET['page'])) ? $_GET['page'] : 1;
$offset = ($pageNum - 1) * $rowsPerPage;
$pagestoshow = 10;

$logs = FeefoReviewsLogs::orderBy('created_at', 'DESC')->skip($offset)->take($rowsPerPage)->get();
$totalnumrows = $logs->count();

if (!empty($_REQUEST['action']) && $_REQUEST['action'] == 'search') {

    $logs = FeefoReviewsLogs::where(function ($query) {
        if (!empty($_REQUEST['order_id'])) {
            $query->orWhere('request', 'like', '%'.$_REQUEST['order_id'].'%');
        }

        if (!empty($_REQUEST['date'])) {
            $tmp_date = explode('/', $_REQUEST['date']);
            $db_date = $tmp_date[2].'-'.$tmp_date[1].'-'.$tmp_date[0];
            $query->orWhere('created_at', 'like', '%'.$db_date.'%');
        }
    })->get();

    $append .= '&order_id=' . $_REQUEST['order_id'];
    $append .= '&date=' . $_REQUEST['date'];

}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/plugins/FeefoReviews/admin/index.php">Feefo Reviews</a> /</li>
    <li class="end">Logs</li>
</ul>
<h1>Feefo Reviews Logs</h1>

<?php
require_once 'tabnav.php';
?>

<form action="logs.php" method="get" class="style">
    <fieldset class="show">
        <h1><a class="show el">Search <i class="fa fa-caret-right"></i></a></h1>
        <div class="row">
            <label for="order_id">Order ID</label>
            <input type="text" name="order_id" id="order_id" value="<?= clean_page($_REQUEST['order_id']) ?>" />
        </div>
        <div class="row">
            <label for="date">Date</label>
            <input type="text" name="date" id="date" value="<?= clean_page($_REQUEST['date']) ?>" class="datepicker" />
        </div>

        <input type="hidden" name="action" value="search">
        <div class="search-button">
            <input type="submit" value="Search" class="BUTTON" />
        </div>
    </fieldset>
</form>

<?php
if ($logs->count() > 0) {
    include $path . 'core/admin/templates/pagination.php';
    ?>

    <table class="manage-items">
        <tr>
            <th>Order</th>
            <th>Response</th>
            <th class="center">Created at</th>
        </tr>
        <tbody class="tabular">
            <?php
            foreach ($logs as $log) {
                $feefo_request = json_decode($log['request']);
                $feefo_response = json_decode($log['response']);

                $order_id = null;
                if (!empty($feefo_request->orderref)) {
                    $order_id = $feefo_request->orderref;
                } elseif (!empty($feefo_request->order)) {
                    $order_id = $feefo_request->order->info->order_id;
                }
                ?>
                <tr>
                    <td>
                        <?php if (!empty($order_id)) { ?>
                        <a href="/shop/admin/orders/manage.order.php?id=<?= $order_id ?>" target="_blank"><?= $order_id ?></a>
                        <?php } ?>
                    </td>
                    <td><?= $feefo_response ?></td>
                    <td nowrap><?= clean_page($log['created_at']) ?></td>
                </tr>
                <?php
            }
            ?>
    </table>

    <?php
    include $path . 'core/admin/templates/pagination.php';
} else {
    ?>
    <p>There were no logs found matching your search criteria</p>
    <?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
