<?php

namespace Mtc\Plugins\MembersMessaging\Http\Controllers;

use Mtc\Plugins\MembersMessaging\Http\Resources\ThreadResource;
use Mtc\Core\AdminUser;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Mtc\Plugins\MembersMessaging\Models\Thread;

class AssignThreadsController extends Controller
{
    public function assign(Request $request)
    {
        $adminId = $request->input('id');
        $threadIds = $request->input('threads');

        if (!$adminId) {
            return response()->json([
                'success' => false,
                'message' => "You have provided an invalid Admin ID."
            ], 400);
        }

        if (!$threadIds) {
            return response()->json([
                'success' => false,
                'message' => "You have provided no selected Threads."
            ], 400);
        }

        $admin = AdminUser::find($adminId);

        $threads = Thread::whereIn('id', $threadIds);

        $count = $threads
            ->update(['admin_id' => $admin->id]);

        return response()->json([
            'success' => true,
            'threads' => ThreadResource::collection(Thread::all()),
            'message' => "Successfully assigned $count threads to $admin->name."
        ], 200);
    }

    public function unassign(Request $request)
    {
        $threadIds = $request->input('threads');

        if (!$threadIds) {
            return response()->json([
                'success' => false,
                'message' => "You have provided no selected Threads."
            ], 400);
        }
        $threads = Thread::whereIn('id', $threadIds);

        $count = $threads
            ->update(['admin_id' => null]);

        return response()->json([
            'success' => true,
            'threads' => ThreadResource::collection(Thread::all()),
            'message' => "Successfully unassigned $count threads."
        ], 200);
    }

    // TODO: Rewrite this
    public function find(Request $request)
    {

        $id = $request->input('id');
        $threads = Thread::query();

        $count = 0;
        $message = "";

        if ($id === "0") {
            $threads = $threads
                ->whereIn('admin_id', [0])
                ->orWhereNull('admin_id')
                ->get();

            $count = $threads->count();
            $message = "Showing $count unassigned threads.";
        } else if (!$id) {
            $threads = $threads->get();
            $message = "Showing all threads.";
        } else {

            $admin = AdminUser::find($id);

            if (!$admin) {
                return response()->json([
                    'success' => false,
                    'message' => "Admin with ID $id not found."
                ], 400);
            }

            $threads = $threads
                ->where('admin_id', $id)
                ->get();

            $message = "Showing $count threads for $admin->name";
        }

        return response()->json([
            'success' => true,
            'threads' => ThreadResource::collection($threads),
            'message' => $message,
        ]);
    }
}
