<?php

namespace Mtc\Plugins\MembersMessaging\Http\Controllers;

//use App\CustomerEmailHistory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Mtc\Modules\Members\Classes\Auth;
use Mtc\Core\AdminUser;
use Mtc\Plugins\MembersMessaging\Models\Message;
use Mtc\Plugins\MembersMessaging\Models\Thread;

/**
 * Controller for "Member-side" Threads.
 */
class MemberThreadController extends Controller
{

    /**
     * @return string
     */
    public function index()
    {
        $member = Auth::getLoggedInMember();

        $page_meta['title'] = config('app.name') . ' - Messages';

        $threads = Thread::scopeForMember($member->id);

        return app('twig')->render('membersmessaging/member/threads.twig', [
            'page_meta' => $page_meta,
            'threads' => $threads,
            'member' => $member,
        ]);
    }

    /**
     * @return string
     */
    public function create()
    {
        $page_meta['title'] = config('app.name') . ' - Messages';

        return app('twig')->render('membersmessaging/member/thread_create.twig', [
            'page_meta' => $page_meta,
            'categories' => Thread::THREAD_CATEGORIES,
        ]);
    }

    /**
     * Store a new Thread.
     * 
     * @param Request $request
     * @return RedirectResponse
     */
    public function store(Request $request): RedirectResponse
    {
        $validated = $request->validate([
            'title' => 'required|string',
            'text' => 'required|string',
            'category' => 'required|integer',
        ]);

        $member = Auth::getLoggedInMember();

        $thread = Thread::create([
            'title' => $validated['title'],
            'url' => str_replace('.', '-', uniqid('cp_', true)),
            'category' => $validated['category'],
            'member_id' => $member->id,
            'status' => 1
        ])->messages()->create([
            'member_id' => $member->id,
            'text' => $validated['text'],
        ]);

        return redirect()->route('messaging.index');
    }

    public function show(string $url)
    {
        $page_meta['title'] = config('app.name') . ' - Messages';

        $member = Auth::getLoggedInMember();

        $thread = Thread::whereUrl($url)
            ->first();

        // If a member is trying to gain access, check to see if they belong to this thread.
        if($thread->member_id !== $member->id) {
            return redirect(route('members-dashboard', [], false));
        }

        $thread->messages()
            ->whereNull('read_at')
            ->update(['read_at' => now()]);

        $messages = $thread->public_messages()->map(function ($message) {
            $message->diff = $message->created_at->diffForHumans();
            return $message;
        });

        return app('twig')->render('membersmessaging/member/messages.twig', [
            'page_meta' => $page_meta,
            'messages' => $messages,
            'thread' => $thread,
            'url' => $thread->url,
            'satisfactory_options' => SatisfactoryController::$satisfactory_options,
        ]);
    }
}
