<?php

namespace Mtc\Plugins\MembersMessaging\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ThreadResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'status' => $this->status,
            'status_name' => $this->status_name,
            'category_name' => $this->category_name,
            'threadMemberName' => $this->getThreadMemberName(),
            'threadAdminName' => $this->getThreadAdminName(),
            'url' => $this->url,
            'unread_class' => $this->getUnreadStatusString(true),
            'last_updated' => $this->updated_at->toDateTimeString()
        ];
    }
}
