<?php

namespace Mtc\Plugins\MembersMessaging;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\ServiceProvider;
use Mtc\Plugins\MembersMessaging\Http\Middleware\ThreadPermissionMiddleware;

class MembersMessagingServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->loadMigrationsFrom(__DIR__.'/../database/migrations');
        $this->mergeConfigFrom(__DIR__.'/config/membersmessaging.php', 'membersmessaging');

        $paths = config('view.paths');
        $paths[] = realpath(__DIR__ . '/templates');

        Config::set('view.paths', $paths);

        $this->registerEvents();
        $this->registerRelationships();

    }

    protected function registerEvents(): void
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot() {

        $router = $this->app['router'];

        $router->aliasMiddleware('thread.permission', ThreadPermissionMiddleware::class);

        $this->loadRoutesFrom(__DIR__.'/routes/web.php');
    }

    protected function registerRelationships(): void
    {

    }
}
