<?php

namespace Mtc\Plugins\MembersMessaging\Models\Traits;

use Mtc\Core\Admin\Role;

trait ThreadParticipant
{
    public function getDisplayName() {
        if(isset($this->fullname)) {
            return $this->fullname;
        }

        if(isset($this->name)) {
            return $this->name;
        }

        return '';
    }

    public function getDisplayEmail() {
        if(isset($this->email)) {
            return $this->email;
        }

        return '';
    }

    public function getDisplayType() {
        if(isset($this->role)) {
            return Role::find($this->role)->name ?? 'No role';
        }

        return 'Member';
    }
}
