# MembersMessaging

*Messaging plugin for pharmacy starter, rewritten to follow MVC architecture.*

This plugin contains a full rewrite for the previous MembersMessaging plugin. The role of the plugin is to provide a channel of communication between the Members and the Administrators on behalf of our clients. 

The plugin was written with Laravel best practices in mind and makes use of various features from the Framework. Previously, files were written in a mixture of PHP/HTML and included potential for JS and CSS but those were not populated.

The logic from the PHP files has been seperated into Models and Controllers and the HTML has been rewritten in Twig. To tie the frontend together, Less and Javascript has been used.

## Core Changes 
---

### `plugins/MembersMessaging`

- Added a service provider to load routes, configs and templates for the plugin.
- Added a README.md

### `plugins/MembersMessaging/config`

- Added some defaults for prefixes and settings.

### `plugins/MembersMessaging/css`, `plugins/MembersMessaging/js`

- Added some styling for pages under this plugin.
- Added some interactive elements for this plugin.

### `plugins/MembersMessaging/Http`

- Refactored logic from old PHP files into Controllers.
- Added some middleware to handle permissions for Threads.
- `AdminMessagesController` - Receives messages and stores them into the database. Returns a JSON Response.
- `AdminThreadController`:
  - `index` handles rendering the main Threads table. Scopes for the current logged in admin.
  - `show` handles rendering viewing a particular Thread. Scopes for the current logged in admin.
  - `fetch` has a function for fetching Threads. This is scope just for the current admin. It returns a JSON response to be dynmaically loaded on the front-end.
  - `archive` handles soft deletes of Threads.
  - `delete` handles hard deletes of Threads.
  - `star` helps to prioritise threads. Threads marked as 'starred' hold priority when being rendered.
  - `markOpen` marks a Thread with the status open.
  - `markClose` marks a Thread with the status closed. This puts it lower in priority.
  - `filter` scopes the Threads and then returns a response that shows messages with that status.
  - `restore` brings Soft Deleted Threads back.
  - `messageMember` is a feature from `manage.order.php` and was added as a piece of required functionality. It opens a new Thread regarding a particular order.
- `AssignThreadController`
  - `assign` handles assignment of an admin to a Thread.
  - `unassign` handles unassignment of an admin to a Thread.
  - `find` helps find Threads assigned to an admin.
- `MemberMessageController` - Receives messages and stores them into the database and returns a JSON response.
- `MemberThreadController`:
  - `index` handles displaying all the threads for a member.
  - `create` handles displaying a form for opening a new thread.
  - `store` handles opening a new thread.
  - `show` shows a particular thread for a Member.
- `ResponseTimes`: Moved a lot of the logic from Messages to its own controller.
- `SatisfactoryController`: Moved logic from the Thread to its own controller. It will now display a panel for stats on satisfactory ratings and store them from a member.
- Added Middleware to make sure the user has Permissions for a particular thread.
- Added a resource to pull data through to the client side without dumping the whole object.
- `TemplateController`: handles everything for templates.

### `plugins/MembersMessaging/Models`
- `ThreadParticipant` is a trait that provides common functions between `Member` and `AdminUser` that are primarily used in templates.
- `Message` model for a message. Text should be encrypted.
- `Template` model for a template.
- `Thread` model for a thread. Titles should be encrypted. Has relations to Members, Admins and Orders.

### `plugins/MembersMessaging/routes`

### `plugins/MembersMessaging/templates`
