<?php

use Illuminate\Support\Facades\Route;
use Mtc\Plugins\MembersMessaging\Http\Controllers\AdminMessagesController;
use Mtc\Plugins\MembersMessaging\Http\Controllers\AdminThreadController;
use Mtc\Plugins\MembersMessaging\Http\Controllers\MemberThreadController;
use Mtc\Plugins\MembersMessaging\Http\Controllers\SatisfactoryController;
use Mtc\Plugins\MembersMessaging\Http\Controllers\TemplatesController;
use Mtc\Plugins\MembersMessaging\Http\Controllers\AssignThreadsController;
use Mtc\Plugins\MembersMessaging\Http\Controllers\MemberMessagesController;
use Mtc\Plugins\MembersMessaging\Http\Controllers\ResponseTimes;

/**
 * MEMBER AREA
 */
$memberPrefix = trim(config('membersmessaging.prefix', '/members/messaging/'), '/');

Route::prefix($memberPrefix)
    ->middleware(['members:auth', 'account.verified'])
    ->name('messaging.')
    ->group(function () {

        // Member Threads (root actions)
        Route::get('/', [MemberThreadController::class, 'index'])->name('index');
        Route::post('/', [MemberThreadController::class, 'store'])->name('submit');
        Route::get('/create', [MemberThreadController::class, 'create'])->name('thread');

        // /threads subgroup
        Route::prefix('threads')->group(function () {
            Route::get('/{url}', [MemberThreadController::class, 'show'])->name('view_thread');
        });

        // Member Messages
        Route::post('/message', [MemberMessagesController::class, 'store'])->name('reply');

        // Handling Satisfactory
        Route::post('/satisfactory', [SatisfactoryController::class, 'store'])->name('satisfactory');
    });

/**
 * ADMIN AREA
 */
Route::prefix('admin/members/messaging')
    ->middleware(['web', 'auth'])
    ->name('admin.messaging.')
    ->group(function () {

        // Threads (root)
        Route::get('/', [AdminThreadController::class, 'index'])->name('index');
        Route::get('/fetch', [AdminThreadController::class, 'fetch'])->name('fetch');

        // Messaging (reply + compose to member)
        Route::post('/message', [AdminMessagesController::class, 'store'])->name('reply');
        Route::get('/order/{order}', [AdminThreadController::class, 'messageForOrder'])->name('message_member');

        // /threads subgroup
        Route::prefix('threads')->group(function () {
            Route::get('/{url}', [AdminThreadController::class, 'show'])->name('view_thread');

            // Operations
            Route::post('/mark-open', [AdminThreadController::class, 'markOpen'])->name('open');

            // NOTE: Name intentionally kept as "open" to match the original file usage.
            Route::post('/mark-closed', [AdminThreadController::class, 'markClosed'])->name('open');

            Route::post('/star', [AdminThreadController::class, 'star'])->name('star');

            // Filter
            Route::post('/filter', [AdminThreadController::class, 'filter'])->name('filter');

            Route::post('/create-thread', [AdminThreadController::class, 'createThread'])->name('createThread');

            // Sensitive Operations (permissioned)
            Route::middleware(['thread.permission:VIEW_ALL_THREADS'])->group(function () {
                Route::post('/archive', [AdminThreadController::class, 'archive'])->name('archive');
                Route::delete('/trash', [AdminThreadController::class, 'delete'])->name('delete');
                Route::post('/restore', [AdminThreadController::class, 'restore'])->name('restore');

                // Assignment
                Route::post('/find', [AssignThreadsController::class, 'find'])->name('find');
                Route::post('/assign', [AssignThreadsController::class, 'assign'])->name('assign');
                Route::post('/unassign', [AssignThreadsController::class, 'unassign'])->name('unassign');
            });
        });

        // Response Times (invokable)
        Route::get('/response-times', ResponseTimes::class)->name('response_times');

        // Templates subgroup
        Route::prefix('templates')->group(function () {
            Route::get('/', [TemplatesController::class, 'index'])->name('templates');
            Route::get('/create', [TemplatesController::class, 'create'])->name('add_template');
            Route::post('/', [TemplatesController::class, 'store'])->name('submit_template');
            Route::get('/{id}/edit', [TemplatesController::class, 'edit'])->name('edit_template');
            Route::patch('/{id}', [TemplatesController::class, 'update'])->name('save_template');
            Route::delete('/{id}', [TemplatesController::class, 'destroy'])->name('delete_template');
        });

        // Special single-template fetch path (kept outside /templates to preserve URI)
        Route::get('/template/{id}', [TemplatesController::class, 'fetchTemplate'])->name('fetch_template');

        // Satisfactory (list)
        Route::get('/satisfactory', [SatisfactoryController::class, 'index'])->name('satisfactory');
    });
