<?php
/**
 * Static Block Instance template.
 * Allows defining content of static block
 * Has its own template to support multiple data instances for one block
 *
 * @category Plugins
 * @package  Mtc_Static_Blocks
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

$unique = uniqid();

?>
<div class="instance clearfix">
    <div class="row tinymce">
        <label for="tinymce_<?= $instance->id ? $instance->id : $unique ?>">
            Content
        </label>
        <textarea name="tinymce[<?= $instance->id ?>]"
                  id="tinymce_<?= $instance->id ? $instance->id : $unique ?>"
                  class="simpletinymce">
            <?= $instance->content ?>
        </textarea>
    </div>
    <div class="row text">
        <label for="content_<?= $instance->id ? $instance->id : $unique ?>">
            Content
        </label>
        <textarea name="content[<?= $instance->id ?>]"
                  id="content_<?= $instance->id ? $instance->id : $unique ?>"><?= $instance->content ?></textarea>
    </div>
    <div class="row image">
        <label for="alt_text">Alt Text</label>
        <input type="text"
               name="alt_text[<?= $instance->id ?>]"
               id="text"
               value="<?= clean_page($instance->alt_text);?>">
    </div>
    <div class="row image">
        <label for="url">Link</label>
        <input type="text"
               name="url[<?= $instance->id ?>]"
               id="url"
               value="<?= clean_page($instance->url);?>">
    </div>
    <div class="row image">
        <label for="size_<?= $instance->id ? $instance->id : $unique ?>">
            Size
        </label>
        <select name="size[<?= $instance->id ?>]"
                id="size_<?= $instance->id ? $instance->id : $unique ?>">
            <?php
            foreach ($block_sizes as $size) {
                if ($size->id == $instance->size) {
                    $selected = 'selected="selected"';
                } else {
                    $selected = '';
                }
                $display_name = $size->name;
                if ($size->crop || $size->forced) {
                    $display_name .= ' (' . $size->width . 'x' . $size->height . ')';
                }
                ?>
                <option value="<?= clean_page($size->id) ?>" <?= clean_page($selected) ?>>
                    <?= clean_page($display_name) ?>
                </option>
                <?php
            }
            ?>
        </select>
    </div>
    <div class="row image">
        <?php
        if ($instance->image != '') { ?>
            <div class="row image">
                <label>
                    Image
                </label>
                <img src="/uploads/images/static_blocks/<?= clean_page($block_sizes[1]->name) ?>/<?= clean_page($instance->image) ?>" />
            </div>
            <div class="row image">
                <label for="delete_image">
                    Delete Image
                </label>
                <input type="checkbox"
                       id="delete_image"
                       name="delete_image[<?= $instance->id ?>]"/>
            </div>
            <?php
        }
        ?>
        <div class="row image">
            <label for="image_<?= $instance->id ? $instance->id : $unique ?>">
                Upload
            </label>
            <input id="image_<?= $instance->id ? $instance->id : $unique ?>"
                   type="file"
                   name="userfile_<?= $instance->id ? $instance->id : $unique ?>"/>
        </div>
    </div>
    <?php
    if (STATIC_BLOCKS_INSTANCE_COUNT > 1 && !empty($instance->id)) {
        ?>
        <div class="row checkboxRow image tinymce text">
            <label for="remove_<?= $instance->id ? $instance->id : $unique ?>">
                Remove?
            </label>
            <input type="checkbox"
                   name="remove[<?= $instance->id ?>]"
                   id="remove_<?= $instance->id ? $instance->id : $unique ?>"/>

        </div>
        <?php
    }
    ?>
</div>
