# Bundles


## How to install

Add the following service provider class to `/config/app.php`:
`\MtcPharmacy\Bundles\BundlesServiceProvider::class` (for routes & migrations to work).

Run migrations (e.g. `php artisan migrate`)


### Issues

To discover the templates you might need to edit `/core/includes/header.inc.php`:

```php
$view_paths = Config::get('view.paths');

foreach ($view_paths as $view_path) {
    $template_paths[] = $view_path;
}
```

## How to use

e.g.

```
import BundleCreator from '../../plugins/mtc_pharmacy_bundles/src/assets/js/components/bundle_creator.vue';
Vue.component('bundle-creator', BundleCreator);

...

<bundle-creator
    :preselected-item-ids="{{ qualified_items.pluck('id').toJson() }}"
    :available-items="{{ items.toJson() }}"
    url-submit-selected-items="{{ route('shop-bundles-add-to-basket') }}"
></bundle-creator>
```

To edit an existing bundle, used `bundle_types`.`url` field. This is a page that will contain `<bundle-creator>` component and can be populated from the passed into it bundle ID.
