<?php

ini_set('max_input_vars', 10000);
$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$page_meta['title'] = 'Incompatible Categories';

$errors = [];

require_once $path . 'core/admin/templates/adminheader.html.php';

$incompatibilities = (new \Mtc\Shop\Incompatibility())->get();

?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>

    <li class="end">Incompatible Categories</li>
</ul>

<h1>Incompatible Categories</h1>
<?php

include __DIR__ . '/tabnav.php';

if (count($errors)>0) { showerrors($errors); }
?>
<div class="row">
    <a href="/shop/admin/ingredients/incompatible.categories.edit.php" class="btn">Add New</a>
</div>
<?php
if (count($incompatibilities) > 0) {
    $header = '<tr>
                <th nowrap="">Incompatible Categories</th>
                <th>Message</th>
                <th class="center">Edit</th>
                <th class="center">Delete</th>
            </tr>';
    ?>
    <form method="post">
        <table class="manage-items">
            <tbody class="tabular">
            <?php
            $i = 0;
            foreach ($incompatibilities as $incompatibility) {
                if ($i % 21 === 0) {
                    echo $header;
                }
                ?>
                <tr>
                    <td>
                        <ul>
                        <?php
                        foreach ($incompatibility->categories as $category) {
                            echo '<li>' . $category->name . '</li>';
                        }
                        ?>
                        </ul>
                    </td>
                    <td><?= $incompatibility->message; ?></td>
                    <td class="center"><a href="incompatible.categories.edit.php?id=<?=$incompatibility->id; ?>" class="edit" ><i class="fa fa-pencil"></i></a></td>
                    <td class="center"><a href="incompatible.categories.php?action=delete&delete_id=<?=$incompatibility->id; ?>" class="alert picto error" title="Are you sure you want to delete Incompatible Categories?"><i class="fa fa-times-circle"></i></a></td>
                </tr>
                <?php
                ++$i;
            }
            ?>
            </tbody>
        </table>
    </form>
    <?php
} else {
    ?>
    <div class="row clear">No Incompatible Categories have been created</div>
    <?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
