Vue.component('multimedia-select', {

    props: [
        "options",
        "preselectedOptionId",
        "fieldName",
    ],

    data: function() {
        return {
            selected_option_id: '',
        };
    },

    mounted: function() {
        if (this.preselectedOptionId) {
            this.selected_option_id = this.preselectedOptionId;
        }
    },

    computed: {
        selectedOption: function() {
            let selected_option = {};

            this.options.forEach((o) => {
                if (o.id == this.selected_option_id) {
                    selected_option = o;
                }
            });

            return selected_option;
        },
    },

    template: `
        <section style="float: right; width: 84%;">

            <select :name="fieldName" v-model="selected_option_id">
                <option value="">--- select ---</option>
                <option
                    v-for="option in options"
                    :value="option.id"
                    v-text="option.label"
                ></option>
            </select>

            <br />
            <br />
            <br />

            <img :src="selectedOption.file_url"
                width="300"
            />

        </section>
    `,

});
