Vue.component('print-labels-manager-total', {

    props: [
        "currentValue",
        "maxValue",
    ],


    computed: {

        isOver: function() {
            return (parseInt(this.currentValue) > parseInt(this.maxValue))
        },

        isUnder: function() {
            return (parseInt(this.currentValue) < parseInt(this.maxValue))
        },

    },


    methods: {

    },

    template: `
        <section>

            <div
                :style="(isOver ? 'font-weight: bold; color: red;' : '') + (isUnder ? 'font-weight: bold; color: silver;' : '')"
            >
                <span v-text="currentValue"></span> of <span v-text="maxValue"></span>
            </div>

        </section>
    `,

});

