<div class="items">
    <table>
        <?php

        use Mtc\Core\Permissions;

        foreach ($order->getItems() as $order_item_id => $line) {
            // In the Processing view hide all refunded items
            if ($_REQUEST['order_type'] === 'processing') {
                if (\Mtc\Plugins\Refunds\Classes\RefundItem::query()->where('order_item_id', '=', $order_item_id)->where('quantity', '>', '0')->exists()) {
                    continue;
                }
            }
            $item = new Item();
            $item->Get_Item($line['item_id']);
            $item_eloquent = $item->eloquent();
            $orderItem = \Mtc\Shop\Order\Item::query()
                ->find($order_item_id);
            if ($item_eloquent !== null && Permissions::isReviewer() && (int)$line['approved'] === 0 && \Mtc\Shop\Order\Item::orderItemCanBeApproved($orderItem)) {
                $orders_to_review[] = $order->getId();
            }
            ?>
            <tr<?= $line['PLU'] === 'private_prescription' ? ' class="privatePrescriptionItemRow"' : ''; ?>>
                <td>
                    <?= $line['quantity'] ?>x
                </td>
                <td colspan="2">
                    <a href="<?= $item->url; ?>" target="_blank">
                        <?= clean_page($line['item_name']); ?>
                        <?= $line['PLU'] === 'private_prescription' ? ' <strong>(PP)</strong>' : ''; ?>
                    </a><?= $line['preorder'] ? ' - <span style="color:orange;">preordered</span>' : ''; ?>

                </td>
                <td><?= clean_page(urldecode($line['size'])); ?></td>
                <td>
                    <?php
                    // If approved, always show green check
                    if ((int)$line['approved'] === \Mtc\Shop\Order\Item::ORDER_ITEM_APROVED) {
                        ?>
                        <i class="fa fa-check green" title="Approved"></i>
                        <?php
                        // Only show the red block if the order is not in status 'Pending review'
                        // and the item is not approved
                    } elseif ((int)$line['approved'] === \Mtc\Shop\Order\Item::ORDER_ITEM_REJECTED) {
                        ?>
                        <i class="fa fa-ban red" title="Rejected"></i>
                        <?php
                    } elseif ((int)$order->status === \Mtc\Shop\Order::STATUS_WAITING_FOR_RESPONSE) {
                        ?>
                        <i class="fa fa-info-circle" title="Waiting for response" style="color:#e5a553;"></i>
                        <?php
                    } else {
                        ?>
                        <i class="fa fa-hourglass" title="Pending Review" style="color:#e5da51;"></i>
                        <?php
                    }
                    if ($line['clinic_checked']) {
                        ?>
                        <i class="fa fa-check-circle green" title="Clinically Checked"></i>
                        <?php
                    }
                    ?>
                </td>
            </tr>
            <?php
        }
        ?>
    </table>
</div>