<?php

use Mtc\Shop\PlaceholderImage;


$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'id' => null,
]);

$placeholder_data = PlaceholderImage::get()->toArray();

$placeholder_images = [];

$item = [
    'skip' => false,
];

foreach ($placeholder_data as $key => $image_data) {
    $item = $image_data + $item;

    switch ($item['name']) {
        case 'item_small':
            $item['folders'] = $image_folders['product_folders'];
            $item['preview_size'] = $image_folders['product_folders']['thumbs'];
            $item['target_size'] = $image_folders['product_folders']['thumbs'];
            $item['title'] = 'Item Small Image';
            break;
        case 'category':
            if (CATEGORIES_IMAGE === false) {
                $item['skip'] = true;
            }

            $item['folders'] = $image_folders['category_images'];
            $item['preview_size'] = $image_folders['category_images']['thumbs'];
            $item['target_size'] = $image_folders['category_images']['normal'];
            $item['title'] = 'Category Image';
            break;
         case 'brand':
            if (BRANDS_IMAGES === false) {
                $item['skip'] = true;
            }

            $item['folders'] = $image_folders['brand_images'];
            $item['preview_size'] = $image_folders['brand_images']['small'] ?? null;
            $item['target_size'] = $image_folders['brand_images']['normal'] ?? null;
            $item['title'] = 'Brand Image';
            break;
        default:
            $item['folders'] = $image_folders['product_folders'];
            $item['preview_size'] = $image_folders['product_folders']['thumbs'];
            $item['target_size'] = $image_folders['product_folders']['large'];
            $item['title'] = 'Item Large Image';
            break;
    }

    $item['field_name'] = $item['name'] . '_image';
    $item['delete_field_name'] = 'delete_' . $item['name'] . '_image';

    if (!$item['skip']) {
        $placeholder_images[$item['name']] = $item;
    }
}

$display_form = true;

$page_meta['title'] = 'Placeholder images';

if ($_REQUEST['action'] == 'update') {

    foreach ($placeholder_images as $item_name => $item) {

        if ($_FILES[$item['field_name']]['size'] > 0) {

            if ($filedata = upload_image($item['field_name'], $item['folders'])) {
                $filename = $filedata['name'];

                if (!empty($filedata['error'])) {
                    $errors[] = $filedata['error'];
                }

                PlaceholderImage::where('name', '=', $item_name)->update(['value' => $filename]);

                $placeholder_images[$item_name]['value'] = $filename;

            } else {
                $errors[] = 'Image failed to upload';
            }

        } elseif (!empty($_REQUEST[$item['delete_field_name']])) {

            $delete_data = PlaceholderImage::where('name', '=', $item_name)->get()->toArray();

            if (!empty($delete_data)) {
                foreach ($delete_data as $key => $delete_item) {
                    foreach ($item['folders'] as $folder) {
                        unlink(SITE_PATH . '/' . $folder['path'] . '/' . $delete_item['value']);
                    }
                }
            }

            PlaceholderImage::where('name', '=', $item_name)->update(['value' => '']);

            $placeholder_images[$item_name]['value'] = '';
        }
    }

}

$tinymce = 2;

require_once $path . 'core/admin/templates/adminheader.html.php';

?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>Placeholder Images</h1>

<?php

if (!empty($errors)) {
    showerrors($errors);
}

if (empty($errors) && isset($_REQUEST['action'])) {
    echo showmsg('Images Updated', "success", $path);
}

if ($display_form === true) {
    ?>
    <form action="<?= $_SERVER['PHP_SELF'] ?>" method="post" enctype="multipart/form-data" class="style">
    <?php
    foreach ($placeholder_images as $item_name => $item_values) {
        ?>
        <fieldset class="show">
            <h1>
                <a class="show el">
                    <?= clean_page($item_values['title']); ?> <i class="fa fa-caret-right"></i>
                </a>
            </h1>
            <div class="hint el">
                <i class="icon fa fa-info-circle"></i>
                <div class="text">
                    W:<?= clean_page($item_values['target_size']['width']) ?>px
                    H:<?= clean_page($item_values['target_size']['height']) ?>px
                </div>
            </div>
            <?php
            if (!empty($placeholder_images[$item_name]['value'])) {
                ?>
                <div class="row">
                    <label>Image</label>
                    <img src="/<?= clean_page($item_values['preview_size']['path']); ?>/<?= clean_page($placeholder_images[$item_name]['value']); ?>" />
                </div>

                <div class="row">
                    <label for="<?= clean_page($item_values['delete_field_name']); ?>"> Delete Image</label>
                    <input id="<?= clean_page($item_values['delete_field_name']); ?>" type="checkbox" name="<?= clean_page($item_values['delete_field_name']); ?>"/>
                </div>
                <?php
            }
            ?>
            <div class="row">
                <label for="<?= clean_page($item_values['field_name']); ?>">Upload</label>
                <input id="<?= clean_page($item_values['field_name']); ?>" type="file" name="<?= clean_page($item_values['field_name']); ?>"/>
            </div>
        </fieldset>
        <?php
        }
    ?>

        <div class="row">

            <input type="hidden" name="action" value="update" />
            <input type="hidden" name="id" value="<?= clean_page($_REQUEST['id']); ?>" />
            <input type="submit" value="Save" />
        </div>
    </form>
    <?php
} else {
    ?>
        Click <a href="manage.categories.php">here</a> to return to the categories.
    <?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';

