# Component Registry

A developer tool for browsing and previewing all Twig components in the pharmacy system.

## Features

- **Component Discovery**: Automatically scans `sites/default/templates/includes/` for all `.twig` components
- **Component Listing**: Grid view with component cards showing name, description, and metadata
- **Category Organization**: Components organized by directory structure
- **Component Preview**: Isolated preview pages showing components with sample data
- **Usage Instructions**: Copy-pasteable include examples with variable documentation
- **Search & Filter**: Search by name/description and filter by category
- **Performance**: Cached component discovery with 5-minute TTL for fast loading

## Usage

### Browse Components
Visit `/component` to see the main component registry page.

### Preview Components
Click any component card to open an isolated preview showing:
- Rendered component with sample data
- Usage instructions
- Required and optional variables
- Component metadata

### API Access
- `GET /api/components` - List all components with pagination and filtering
- `GET /api/components/{path}` - Get detailed component information

## Architecture

### Services
- `ComponentScannerService` - Discovers and caches component metadata
- `ComponentRendererService` - Renders components with sample data

### Models
- `Component` - Represents a discovered Twig component
- `ComponentSampleData` - Generates sample data for component rendering

### Controllers
- `ComponentRegistryController` - Main registry page
- `ComponentPreviewController` - Component preview pages
- `ComponentRegistryApiController` - API endpoints

### Frontend
- Vue.js `component-registry` component for the main listing page
- Isolated Twig layout for component previews

## Configuration

Component registry settings in `config/cache.php`:
```php
'component_registry' => [
    'ttl' => env('COMPONENT_CACHE_TTL', 300), // 5 minutes
    'prefix' => 'component_registry',
    'enabled' => env('COMPONENT_CACHE_ENABLED', true),
],
```

## Caching

Component discovery is cached for 5 minutes by default. To clear the cache:
- Restart the application
- Wait for TTL expiration
- Modify any component file (invalidates based on file modification time)

## Performance

- Page load time: <5 seconds (as per specification)
- Supports 50-200 components efficiently
- File system scanning with intelligent caching
- Lazy loading of component previews

## Error Handling

- Components with syntax errors are detected and marked as non-renderable
- Technical error details displayed for debugging
- Graceful fallbacks for missing components or files
- Comprehensive logging for troubleshooting

## Development

### Adding New Sample Data Patterns
Extend `ComponentSampleData::generateForComponent()` to add support for new component types.

### Testing
- Feature tests in `tests/Feature/Component*Test.php`
- Unit tests in `tests/Unit/Component*ServiceTest.php`

### Extending
The component registry is designed to be extensible. Key extension points:
- Sample data generation
- Component metadata extraction
- Preview layouts and styling
- API response formatting