# Migration from Laravel Mix to Vite
---

This project has been migrated from Laravel Mix (webpack) to Vite for a faster and more modern development experience.

## Changes Made
---

1. Created `vite.config.js` to replace `webpack.mix.js`
2. Updated `package.json` with Vite dependencies and scripts
3. Added a Vite helper function in `header.inc.php`
4. Updated asset references in `main.twig` template
5. Replaced `webpack.mix.js` and `mix-manifest.json` with placeholder files

## How to Complete the Migration
---

1. Install the new dependencies:
   ```bash
   npm install
   ```

2. Build the assets with Vite:
   ```bash
   npm run build
   ```

3. Start the development server:
   ```bash
   npm run dev
   ```
4. Within the .env file, set `VITE_DEV_SERVER` to true for any local development and false for production.

5. Within the .env file, set `VITE_DEV_SERVER_URL` to the URL of your local development server and include the port number. If you are unsure of the port number, check the terminal output of the development server by running `npm run dev`.

6. When on a development server you will need to add `SSL_KEY_PATH` and `SSL_CERT_PATH` to your .env file. To get these certificates, you can access the cpanel of your server and navigate to `SSL/TLS Status`. Then click on `View Certificate`. Within the root of the server i,e, `/home/user/`, there will be a folder called `ssl`. Create a `server.key` and `server.crt` with the keys that were displayed in the cpanel and update the `.env` with the path to these files i.e. `/home/user/ssl/server.key` and `/home/user/ssl/server.crt`.



## Verification
---

You can run the verification script to ensure all migration steps were completed correctly:

```bash
  node vite-test.js
```

## Key Differences from Laravel Mix
---

- **Development Server**: Vite's development server is much faster than Laravel Mix
- **Build Process**: Vite builds are significantly faster
- **Asset References**: Assets are now referenced using the `vite()` helper function instead of `mix()`
- **Module System**: Vite uses ES modules by default, so script tags need `type="module"`

## Troubleshooting
---

If you encounter any issues:

1. Make sure all dependencies are installed: `npm install`
2. Check that the Vite configuration is correct: `node vite-test.js`
3. Clear any cached assets in the browser
4. Check the browser console for errors


## Known Issues
---

### CORS Errors with Multiple Vite Dev Servers
---

**Problem:** CORS errors occur when running multiple Vite dev instances on the same server.

**Root Cause:** 

When multiple developers run Vite in dev mode simultaneously:

1. The first instance takes the default port 5173
2. The second instance automatically switches to port 5174 (or next available)
3. However, the `.env` file still references port 5173 for asset URLs
4. The application tries to load assets from port 5173, but the dev server is actually running on 5174
5. This port mismatch causes the browser to block requests with CORS errors

**Temporary Workaround:**

1. Choose a unique port (e.g., 9000) and set it in your `.env` file in `VITE_DEV_SERVER_URL`
2. Launch Vite with the matching port: `vite --port 9000`
3. Ensure both the `.env` configuration and the dev server use the same port
