<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class FixItemStock extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fix:item-stock';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fix stock for products that have sizes';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {

        \Mtc\Shop\Item::query()
            ->whereHas('sizes')
            ->get()
            ->each(function ($item) {
                echo "Updating {$item->name}\n";
                $item->stock = $item->sizes()->sum('stock');
                $item->save();
            });
    }
}
