<?php

namespace App\Support;

use Illuminate\Support\Facades\Cache;

class MenuCache
{
    protected static array $localCache = [];

    public static function remember(string $key, callable $resolver, int $ttl = 300)
    {
        if (isset(self::$localCache[$key])) {
            return self::$localCache[$key];
        }

        $value = cache()->remember($key, $ttl, $resolver);
        self::$localCache[$key] = $value;

        return $value;
    }
}
