var content_manager = {
    xds: new xds("https://copyhub.mtcassets.com/serve/serve.html"),
    page : null,
    init_time : moment(),
    max_time_without_reload: 900000, // in milliseconds. 3600000 = hour, 900000 = 15min, 1800000 = 30min, 60000 = 1min, 120000 = 2min
    timeout_limit: 30000, // 30 seconds
    timout_counter : 0,
    unsaved_changes : false,
    uncommited_changes : false,
    last_saved: null,
    loading: false,
    loading_started: null,
    version: 0.1,
    debug: 0, // 1 = true, 0 = false
    page_ping: { // Information regarding page ping see pingPage() function in content_manager functions.js for more info
        interval: null,
        interval_time: 60000 * 15, // 15 minutes
    },
    site_tree: null
};

$(function(){

    $(document).on("keypress", 'form', function (e) {
        var code = e.keyCode || e.which;
        if (code == 13) {
            e.preventDefault();
            return false;
        }
    });

    $('#dialog').dialog();
    $('.ui-dialog-titlebar-close').hide();

    $('.cms-buttom-page').off("click"); // cms.js events messing up the flow. shgall remove this after cleanup
    $(".tobBarTab").hide();
    $(".dashboardTab").show();
    $("li.manageListingTab a").click(function(event) {
        ldrPending("loading...");
        loadManageListingPanel();
    });

    $("li.manageParentListingTab a").click(function(event) {
        cmsPreventDefault(event);
        ldrPending("loading...");
        window.location.hash = "#tab=2";
        getPage(
            $(this).data("page-id"),
            function(page){
                treatPage(page);
            }
        );
        return false;
    });

    $("li.dashboardTab a").click(function(event) {
        cmsPreventDefault(event);
        ldrPending("loading...");
        loadIndex();
        return false;
    });

    $("li.updatePageTab a").click(function(event) {
        ldrPending("loading...");
        loadManagePagePanel();
    });

    $("li.historyTab a").click(function(event) {
        ldrPending("loading...");
        loadPageHistoryPanel();
    });

    $("#workArea").ready(function(){
        var page_id, history_page_id;
        page_id = getParameterByName("page");
        history_page_id = getParameterByName("history");
        if ( page_id === "" || page_id === null ) {
            loadIndex();
        } else if ( page_id == "new" ) {
            createNewPage(0);
        } else {
            getPage(
                page_id,
                function(page){
                    treatPage(page);
                },
                history_page_id
            );
        }
    });

    // back button
    // currently only goes one back.
    $(window).on("popstate", function(e) {
        if (e.originalEvent.state !== null) {
            page_id = getHrefPageId(location.href);
            if ( page_id === "" || page_id === null ) {
                loadIndex();
            } else if ( page_id == "new" ) {
                createNewPage(0);
            } else {
                getPage(page_id, function(page){
                    treatPage(page);
                });
            }
        }
    });

    // this is so that the submenu open/close btn doesn't trigger page load
    //$("#site-tree li a i.submenu-button").click(function(event){
    //    return false;
    //});

    //$("#site-tree li a").click(function(event) {
    //    cmsPreventDefault(event);
    //    return anchorClickLoadPage($(this));
    //});

    //$(".cms-buttom-page").click(function(event) {
    //    cmsPreventDefault(event);
    //    return anchorClickLoadPage($(this));
    //});

    $("#workArea fieldset").on("click",function(event) {
        setLayoutStateSession();
    });

    // ####################

    //  NARROW VIEW
    if ( localStorage.getItem("workAreaNarrow") === "true" ) {
        $(".layoutPaddingBtn i").removeClass('fa-list-ul');
        $(".layoutPaddingBtn i").addClass('fa-list');
        $("#workArea").addClass('workAreaNarrow');
    }
    $(".layoutPaddingBtn").click(function(event) {
        var btn = $(this).children('i');
        if ( btn.hasClass('fa-list') ) {
            btn.addClass('fa-list-ul');
            btn.removeClass('fa-list');
            $("#workArea").removeClass('workAreaNarrow');
            try {
                localStorage.setItem("workAreaNarrow", "false");
            } catch(e) {
                if ( isLocalStorageQuotaExceeded(e) ) {
                    localStorage.clear();
                }
            }
        } else {
            btn.removeClass('fa-list-ul');
            btn.addClass('fa-list');
            $("#workArea").addClass('workAreaNarrow');
            try {
                localStorage.setItem("workAreaNarrow", "true");
            } catch(e) {
                if ( isLocalStorageQuotaExceeded(e) ) {
                    localStorage.clear();
                }
            }
        }
        return false;
    });

    init();

});
