<?php

use Mtc\Core\Models\SeoSetting;

/**
 * Seo settings class
 *
 * @author Lukas Giegerich | mtc.
 * @version 2014-01-20
 */
class SeoSettings extends Seo
{

    /**
     * list of seo settings
     * @var array
     */
    public array $settings = [];

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * gets all seo settings from db
     */
    public function getSettings(): array
    {
        return SeoSetting::all()
            ->keyBy('key')
            ->toArray();
    }

    /**
     * Gets the value of an seo setting based on a given key.
     *
     * @param string $key
     * @return string
     */
    public static function getSettingValue($key): string
    {
        if (!$setting = SeoSetting::query()->where('key', $key)->first()) {
            return '';
        }
        return $setting->value;
    }

    /**
     * updates setting with given key using value
     *
     * @param string $key
     * @param string $value
     */
    public function updateSettingValue(string $key, string $value): void
    {
        SeoSetting::query()
            ->where('key', $key)
            ->update([
                'value' => $value
            ]);

        // Clear the cached value for this specific setting
        Cache::forget("seo_setting_{$key}");
    }

}
