<?php
/**
 * @author Aleksey Lavrinenko
 * @version 08.01.2016.
 */

// enable output buffering if not enabled to prevent "Headers already sent" error. FirePHP sends it's logs using
// headers
if (ob_get_status()['level'] === 0) {
    ob_start();
}

ini_set('display_errors', 1);
error_reporting(E_ALL);

/**
 * This error handler will redirect non-fatal error to FirePHP. If a fatal error is reported, will throw an exception.
 */
set_error_handler(function ($errno, $errstr, $errfile, $errline) {
    switch ($errno) {
        case E_NOTICE:
            $error_type = 'Notice';
            break;
        case E_WARNING:
            $error_type = 'Warning';
            break;
        case E_STRICT:
            $error_type = 'Strict';
            break;
        case E_DEPRECATED:
            $error_type = 'Deprecated';
            break;
        default:
            $fatal = true;
            $error_type = 'Error';
            break;
    }

    $message = "$error_type: $errstr \n in $errfile \n on line $errline";
    \FirePHP::getInstance(true)->error($message);

    if (!empty($fatal)) {
        throw new ErrorException($errstr, $errno, 1, $errfile, $errline);
    }
});
