<?php

namespace Mtc\Core\Admin;

use Illuminate\Database\Eloquent\Model;

class RolePermission extends Model
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'admin_role_permissions';

    /**
     * @var string[] $fillable attributes that can be auto-filled
     */
    protected $fillable = [
        'role_id',
        'permission_id'
    ];


    /**
     * Relationship with a Role
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function role()
    {
        return $this->belongsTo(Role::class, 'role_id');
    }

}